% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TRI0-model.R
\name{TRI0}
\alias{TRI0}
\alias{TRI0.default}
\alias{TRI0.TRI}
\alias{TRI0.PATH0}
\alias{TRI0.PATH}
\title{TRI0 model, structural triangulations}
\usage{
TRI0(x, ...)

\method{TRI0}{default}(x, ...)

\method{TRI0}{TRI}(x, ...)

\method{TRI0}{PATH0}(x, ...)

\method{TRI0}{PATH}(x, ...)
}
\arguments{
\item{x}{object understood by silicate (sf, sp, a silicate model, etc.)}

\item{...}{currently unused}
}
\value{
TRI0 model with tables 'object', 'vertex'
}
\description{
TRI0 creates a constrained triangulation using 'ear-cutting', or 'ear-clipping' of
polygons.
}
\details{
Ear-cutting is inherently path-based, so this model is only available for
path-based structures, like simple features, \code{\link[=PATH]{PATH()}}, \code{\link[=PATH0]{PATH0()}} and \code{\link[=ARC]{ARC()}}.
}
\examples{
tri <- TRI0(minimal_mesh)
print(tri)
plot(tri)
}
