% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BinomTest.R
\name{wrapBinomTest.logical}
\alias{wrapBinomTest.logical}
\title{Wrap binom.test (test of Binomial/Bernoulli rate).}
\usage{
\method{wrapBinomTest}{logical}(x, ..., p = NA,
  alternative = c("two.sided", "less", "greater"), conf.level = 0.95,
  na.rm = FALSE)
}
\arguments{
\item{x}{logical, vector of trials.}

\item{...}{extra arguments passed to binom.test}

\item{p}{number, hypothesized probability of success.}

\item{alternative}{passed to \code{\link[stats]{binom.test}}}

\item{conf.level}{passed to \code{\link[stats]{binom.test}}}

\item{na.rm}{logical, if TRUE remove NA values}
}
\value{
wrapped stat
}
\description{
Wrap binom.test (test of Binomial/Bernoulli rate).
}
\examples{

x = c(rep(FALSE, 3), rep(TRUE, 7))
wrapBinomTest(x)
x = c(rep(FALSE, 15), rep(TRUE, 35))
wrapBinomTest(x)


}
\seealso{
\code{\link{wrapBinomTest}}, \code{\link{wrapBinomTest.htest}}, \code{\link{wrapBinomTestS}}, \code{\link{wrapBinomTest.logical}}, \code{\link{wrapBinomTest.numeric}}, \code{\link{wrapBinomTest.data.frame}}
}
