% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TInterval.R
\name{TInterval.numeric}
\alias{TInterval.numeric}
\title{Student-T tolerance-style interval around an estimate of a mean from observations.}
\usage{
\method{TInterval}{numeric}(x, ..., conf.level = 0.95, na.rm = FALSE)
}
\arguments{
\item{x}{logical, vector of observations.}

\item{...}{extra arguments passed to TInterval}

\item{conf.level}{confidence level to draw interval}

\item{na.rm}{logical, if TRUE remove NA values}
}
\value{
wrapped stat
}
\description{
Student-T tolerance-style interval around an estimate of a mean from observations.
}
\examples{

set.seed(2018)
d <- rnorm(100) + 3.2
TInterval(d)


}
\seealso{
\code{\link{TInterval}}, \code{\link{TIntervalS}}, \code{\link{TInterval.numeric}}, \code{\link{TInterval.data.frame}}
}
