% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EmpiricalFns.R
\name{resampleScoreModel}
\alias{resampleScoreModel}
\title{Studentized bootstrap variance estimate for scoreFn(yValues,modelValues).}
\usage{
resampleScoreModel(modelValues, yValues, scoreFn, ..., na.rm = FALSE,
  returnScores = FALSE, nRep = 100, parallelCluster = NULL)
}
\arguments{
\item{modelValues}{numeric array of predictions (model to test).}

\item{yValues}{numeric/logical array of outcomes, depedendent, or truth values}

\item{scoreFn}{function with signature scoreFn(modelValues,yValues) returning scalar numeric score.}

\item{...}{not used, forces later arguments to be bound by name}

\item{na.rm}{logical, if TRUE remove NA values}

\item{returnScores}{logical if TRUE return detailed resampledScores}

\item{nRep}{integer number of repititions to perform}

\item{parallelCluster}{optional snow-style parallel cluster.}
}
\value{
summaries
}
\description{
Studentized bootstrap variance estimate for scoreFn(yValues,modelValues).
}
\examples{

set.seed(25325)
y <- 1:5
m1 <- c(1,1,2,2,2)
cor.test(m1,y,alternative='greater')
f <- function(modelValues,yValues) {
 if((sd(modelValues)<=0)||(sd(yValues)<=0)) {
   return(0)
 }
 cor(modelValues,yValues)
}
s <- sigr::resampleScoreModel(m1,y,f)
print(s)
z <- (s$observedScore-0)/s$sd # should check size of z relative to bias!
pValue <- pt(z,df=length(y)-2,lower.tail=FALSE)
pValue


}
