% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/run_signalHsmm.R
\name{run_signalHsmm}
\alias{run_signalHsmm}
\title{Predict presence of signal peptide in protein}
\usage{
run_signalHsmm(test_data)
}
\arguments{
\item{test_data}{single protein sequence (\code{character} vector) or list of
sequences. It may be an object of class \code{\link[seqinr]{SeqFastaAA}}.}
}
\value{
An object of class \code{hsmm_pred_list}.
}
\description{
Using the hidden semi-Markov model predict presence of signal peptide in
eukaryotic proteins.
}
\details{
Function \code{signalHsmm} returns respectively probability of presence of
signal peptide, start of signal peptide and the probable cleavage site localization.
If input consists of more than one sequence, result is a data.frame where each column
contains above values for different proteins.
}
\note{
Currently start of signal peptide is naively set as 1 amino acid.
}
\examples{
#run signalHsmm on one sequence
x1 <- run_signalHsmm(benchmark_dat[[1]])

#run signalHsmm on one sequence, but input is a character vector
x2 <- run_signalHsmm(c("m", "a", "g", "k", "e", "v", "i", "f",
"i", "m", "a", "l", "f", "i", "a", "v", "e", "s", "s", "p", "i",
"f", "s", "f", "d", "d", "l", "v", "c", "p", "s", "v", "t", "s",
"l", "r", "v", "n", "v", "e", "k", "n", "e", "c", "s", "t", "k",
"k", "d", "c", "g", "r", "n", "l", "c", "c", "e", "n", "q", "n",
"k", "i", "n", "v", "c", "v", "g", "g", "i", "m", "p", "l", "p",
"k", "p", "n", "l", "d", "v", "n", "n", "i", "g", "g", "a", "v",
"s", "e", "s", "v", "k", "q", "k", "r", "e", "t", "a", "e", "s",
"l"))

#run signalHsmm on list of sequences
x3 <- run_signalHsmm(benchmark_dat[1:3])
#see summary of results
summary(x3)
#print results as data frame
pred2df(x3)
#summary one result
summary(x3[[1]])
plot(x3[[1]])
}
\seealso{
\code{\link{hsmm_pred_list}} \code{\link{hsmm_pred}}
}
\keyword{classif}

