% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signature_obj_operation.R
\name{sig_operation}
\alias{sig_operation}
\alias{sig_names}
\alias{sig_modify_names}
\alias{sig_number}
\alias{sig_attrs}
\alias{sig_signature}
\alias{sig_exposure}
\title{Obtain or Modify Signature Information}
\usage{
sig_names(sig)

sig_modify_names(sig, new_names)

sig_number(sig)

sig_attrs(sig)

sig_signature(sig, normalize = c("row", "column", "raw", "feature"))

sig_exposure(sig, type = c("absolute", "relative"))
}
\arguments{
\item{sig}{a \code{Signature} object obtained either from \link{sig_extract} or \link{sig_auto_extract}.}

\item{new_names}{new signature names.}

\item{normalize}{one of 'row', 'column', 'raw' and "feature", for row normalization (signature),
column normalization (component), raw data, row normalization by feature, respectively.}

\item{type}{one of 'absolute' and 'relative'.}
}
\value{
a \code{Signature} object or data.
}
\description{
Obtain or Modify Signature Information
}
\examples{
## Operate signature names
load(system.file("extdata", "toy_mutational_signature.RData",
  package = "sigminer", mustWork = TRUE
))
sig_names(sig2)
cc <- sig_modify_names(sig2, new_names = c("Sig2", "Sig1", "Sig3"))
sig_names(cc)

# The older names are stored in tags.
print(attr(cc, "tag"))
## Get signature number
sig_number(sig2)
## Get signature attributes
sig_number(sig2)
## Get signature matrix
z <- sig_signature(sig2)
z <- sig_signature(sig2, normalize = "raw")
## Get exposure matrix
## Of note, this is different from get_sig_exposure()
## it returns a matrix instead of data table.
z <- sig_exposure(sig2) # it is same as sig$Exposure
z <- sig_exposure(sig2, type = "relative") # it is same as sig2$Exposure.norm
}
