% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_proxies.R
\name{sg_drop_nodes_delay_p}
\alias{sg_drop_nodes_delay_p}
\alias{sg_drop_edges_delay_p}
\title{Drop nodes or edges with a delay}
\usage{
sg_drop_nodes_delay_p(proxy, data, ids, delay, refresh = TRUE,
  cumsum = TRUE)

sg_drop_edges_delay_p(proxy, data, ids, delay, refresh = TRUE,
  cumsum = TRUE)
}
\arguments{
\item{proxy}{An object of class \code{sigmajsProxy} as returned by \code{\link{sigmajsProxy}}.}

\item{data}{A \code{data.frame} of _one_ node or edge.}

\item{ids}{Ids of elements to drop.}

\item{delay}{Column name containing delay in milliseconds.}

\item{refresh}{Whether to refresh the graph after node is dropped, required to take effect, if you are running force the algorithm is killed and restarted at every iteration.}

\item{cumsum}{Whether to compute the cumulative sum of the delay.}
}
\description{
Proxies to dynamically drop multiple nodes or edges to an already existing graph with a *delay* between each removal.
}
\details{
The delay helps for build dynamic visualisations where nodes and edges do not disappear all at the same time.
How the delay works depends on the \code{cumsum} parameter. if \code{TRUE} the function computes the cumulative sum
of the delay to effectively drop each row one after the other: delay is thus applied at each row (number of seconds to wait
before the row is dropped *since the previous row*). If \code{FALSE} this is the number of milliseconds to wait before the node or
edge is added to the visualisation; \code{delay} is used as passed to the function.
}
\note{
Have the parameters from your initial graph match that of the node you add, i.e.: if you pass \code{size} in your initial chart,
make sure you also have it in your proxy.
}
\examples{
\dontrun{
demo("drop-nodes-delay", package = "sigmajs") # add nodes with a delay
demo("drop-edges-delay", package = "sigmajs") # add edges with a delay
demo("drop-delay", package = "sigmajs") # add nodes and edges with a delay
}

}
