% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectizeInputWithButtons.R
\name{selectizeInputWithButtons}
\alias{selectizeInputWithButtons}
\title{selectizeInput with buttons and validation utilities}
\usage{
selectizeInputWithButtons(
  inputId,
  label,
  ...,
  options = NULL,
  container_id = NULL,
  help_id = NULL,
  label_title = NULL,
  btn_titletips = TRUE,
  btn_placement = NULL,
  hide_btns = FALSE
)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{...}{One or more \code{actionButton}'s to appear to right of input element.}

\item{options}{A list of options. See the documentation of \pkg{selectize.js}
for possible options (character option values inside \code{\link[base:AsIs]{base::I()}} will
be treated as literal JavaScript code; see \code{\link[shiny:renderDataTable]{renderDataTable()}}
for details).}

\item{container_id}{id for outer \code{div} (optional). Can use e.g. to add \code{'has-error'} class to style inputs
with \code{shinyjs::addClass}.}

\item{help_id}{id for span with class \code{'help-block'} below input (optional). Can be used for add
error message with \code{shinyjs::html}.}

\item{label_title}{Optional text to appear in info icon tooltip. Used to provide information to user about input.}

\item{btn_titletips}{if \code{TRUE} (default), converts title attributes of \code{actionButtons} into tooltips.}

\item{btn_placement}{Where the \code{actionButton} tooltips should appear (\code{top}, \code{bottom}, \code{left}, \code{right}).
Defaults to \code{'right'} for dropdown buttons and \code{'bottom'} for all others.}

\item{hide_btns}{If \code{TRUE} styling is adjusted so that all buttons are initially hidden. Can unhide buttons
using \code{toggleSelectizeButtons}.}
}
\description{
selectizeInput with buttons and validation utilities
}
\examples{

library(shiny)
library(shinypanel)

ui <- fluidPage(
  div(class = 'row',
      div(class = 'col-sm-12 col-lg-6',
          div(class = 'well-form',
              textAreaInputWithButtons(
                inputId = 'text',
                label = 'Type something:',
                actionButton(
                  'btn3',
                  '',
                  icon('plus', 'fa-fw'),
                  title = 'Click to add something'
                )
              ),
              selectizeInputWithButtons(
                inputId = 'selection',
                label = 'Select something:',
                label_title = 'Information about input',
                actionButton(
                  'btn1',
                  '',
                  icon('tag', 'fa-fw'),
                  title = 'this does something'
                ),
                actionButton(
                  'btn2',
                  '',
                  icon('chevron-right', 'fa-fw'),
                  title = 'this does something else'
                ),
                options = list(multiple = TRUE)
              )
          )
      )
  )
)


server <- function(input, output, session) {

  choices <- reactive({
    paste('Long Option', 1:5)
  })

  observe({
    updateSelectizeInput(session, 'selection', choices = choices())
  })
}

# shinyApp(ui, server)

}
\seealso{
\code{\link[shiny]{selectizeInput}}, \code{\link[shinyjs]{html}},
 \code{\link[shinyjs]{addClass}}, \code{\link{toggleSelectizeButtons}}.
}
