% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chooseSliderSkin.R
\name{chooseSliderSkin}
\alias{chooseSliderSkin}
\title{Theme selector for \code{sliderInput}}
\usage{
chooseSliderSkin(
  skin = c("Shiny", "Flat", "Big", "Modern", "Sharp", "Round", "Square", "Nice",
    "Simple", "HTML5"),
  color = NULL
)
}
\arguments{
\item{skin}{The \code{skin} to apply. Choose among 5 different flavors,
namely 'Shiny', 'Flat', 'Modern', 'Nice', 'Simple', 'HTML5', 'Round' and 'Square'.}

\item{color}{A color to apply to all sliders. Works with following skins:
'Shiny', 'Flat', 'Modern', 'HTML5'. For 'Flat' a CSS filter is applied,
desired color maybe a little offset.}
}
\description{
Customize the appearance of the original shiny's \code{sliderInput}
}
\note{
It is not currently possible to apply multiple themes at the same time.
}
\examples{
if (interactive()) {

library(shiny)
library(shinyWidgets)

# With Modern design

ui <- fluidPage(
  chooseSliderSkin("Modern"),
  sliderInput("obs", "Customized single slider:",
              min = 0, max = 100, value = 50
  ),
  sliderInput("obs2", "Customized range slider:",
              min = 0, max = 100, value = c(40, 80)
  ),
  plotOutput("distPlot")
)

server <- function(input, output) {

  output$distPlot <- renderPlot({
    hist(rnorm(input$obs))
  })

}

shinyApp(ui, server)



# Use Flat design & a custom color

ui <- fluidPage(
  chooseSliderSkin("Flat", color = "#112446"),
  sliderInput("obs", "Customized single slider:",
              min = 0, max = 100, value = 50
  ),
  sliderInput("obs2", "Customized range slider:",
              min = 0, max = 100, value = c(40, 80)
  ),
  sliderInput("obs3", "An other slider:",
              min = 0, max = 100, value = 50
  ),
  plotOutput("distPlot")
)

server <- function(input, output) {

  output$distPlot <- renderPlot({
    hist(rnorm(input$obs))
  })
}

shinyApp(ui, server)

}
}
\seealso{
See \code{\link{setSliderColor}} to update the color of your sliderInput.
}
