% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module-pickerGroup.R
\name{pickerGroup-module}
\alias{pickerGroup-module}
\alias{pickerGroupUI}
\alias{pickerGroupServer}
\title{Picker Group}
\usage{
pickerGroupUI(id, params, label = NULL, btn_label = "Reset filters",
  options = list(), inline = TRUE)

pickerGroupServer(input, output, session, data, vars)
}
\arguments{
\item{id}{Module's id.}

\item{params}{A named list of parameters passed to each \code{\link{pickerInput}}, you can use :
`inputId` (obligatory, must be variable name), `label`, `placeholder`.}

\item{label}{Character, global label on top of all labels.}

\item{btn_label}{Character, reset button label.}

\item{options}{See \code{\link{pickerInput}} options argument.}

\item{inline}{If \code{TRUE} (the default), \code{pickerInput}s are horizontally positioned, otherwise vertically.}

\item{input}{standard \code{shiny} input.}

\item{output}{standard \code{shiny} output.}

\item{session}{standard \code{shiny} session.}

\item{data}{a \code{data.frame}, or an object that can be coerced to \code{data.frame}.}

\item{vars}{character, columns to use to create filters,
must correspond to variables listed in \code{params}.}
}
\value{
a \code{reactive} function containing data filtered.
}
\description{
Group of mutually dependent \code{\link{pickerInput}} for filtering \code{data.frame}'s columns.
}
\examples{
\dontrun{

if (interactive()) {

library(shiny)
library(shinyWidgets)


data("mpg", package = "ggplot2")


ui <- fluidPage(
  fluidRow(
    column(
      width = 10, offset = 1,
      tags$h3("Filter data with picker group"),
      panel(
        pickerGroupUI(
          id = "my-filters",
          params = list(
            manufacturer = list(inputId = "manufacturer", label = "Manufacturer:"),
            model = list(inputId = "model", label = "Model:"),
            trans = list(inputId = "trans", label = "Trans:"),
            class = list(inputId = "class", label = "Class:")
          )
        ), status = "primary"
      ),
      dataTableOutput(outputId = "table")
    )
  )
)

server <- function(input, output, session) {
  res_mod <- callModule(
    module = pickerGroupServer,
    id = "my-filters",
    data = mpg,
    vars = c("manufacturer", "model", "trans", "class")
  )
  output$table <- renderDataTable(res_mod())
}

shinyApp(ui, server)

}


### Not inline example

if (interactive()) {

  library(shiny)
  library(shinyWidgets)


  data("mpg", package = "ggplot2")


  ui <- fluidPage(
    fluidRow(
      column(
        width = 4,
        tags$h3("Filter data with picker group"),
        pickerGroupUI(
          id = "my-filters",
          inline = FALSE,
          params = list(
            manufacturer = list(inputId = "manufacturer", label = "Manufacturer:"),
            model = list(inputId = "model", label = "Model:"),
            trans = list(inputId = "trans", label = "Trans:"),
            class = list(inputId = "class", label = "Class:")
          )
        )
      ),
      column(
        width = 8,
        dataTableOutput(outputId = "table")
      )
    )
  )

  server <- function(input, output, session) {
    res_mod <- callModule(
      module = pickerGroupServer,
      id = "my-filters",
      data = mpg,
      vars = c("manufacturer", "model", "trans", "class")
    )
    output$table <- renderDataTable(res_mod())
  }

  shinyApp(ui, server)

}

}
}
