% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-sliderText.R
\name{sliderTextInput}
\alias{sliderTextInput}
\title{Slider Text Input Widget}
\usage{
sliderTextInput(inputId, label, choices, selected = NULL,
  animate = FALSE, grid = FALSE, hide_min_max = FALSE,
  from_fixed = FALSE, to_fixed = FALSE, from_min = NULL,
  from_max = NULL, to_min = NULL, to_max = NULL,
  force_edges = FALSE, width = NULL, pre = NULL, post = NULL,
  dragRange = TRUE)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{choices}{Character vector to select a value from.}

\item{selected}{The initially selected value, if length > 1, create a range slider.}

\item{animate}{TRUE to show simple animation controls with default settings, for more details see \code{\link[shiny]{sliderInput}}.}

\item{grid}{Logical, show or hide ticks marks.}

\item{hide_min_max}{Hides min and max labels.}

\item{from_fixed}{Fix position of left (or single) handle.}

\item{to_fixed}{Fix position of right handle.}

\item{from_min}{Set minimum limit for left handle.}

\item{from_max}{Set the maximum limit for left handle.}

\item{to_min}{Set minimum limit for right handle.}

\item{to_max}{Set the maximum limit for right handle.}

\item{force_edges}{Slider will be always inside it's container.}

\item{width}{The width of the input, e.g. \code{400px}, or \code{100\%}.}

\item{pre}{A prefix string to put in front of the value.}

\item{post}{A suffix string to put after the value.}

\item{dragRange}{See the same argument in \code{\link[shiny]{sliderInput}}.}
}
\value{
The value retrieved server-side is a character vector.
}
\description{
Constructs a slider widget with characters instead of numeric values.
}
\examples{
\dontrun{

if (interactive()) {

library("shiny")
library("shinyWidgets")

ui <- fluidPage(
  br(),
  sliderTextInput(
    inputId = "mySliderText",
    label = "Month range slider:",
    choices = month.name,
    selected = month.name[c(4, 7)]
  ),
  verbatimTextOutput(outputId = "result")
)

server <- function(input, output, session) {
  output$result <- renderPrint(str(input$mySliderText))
}

shinyApp(ui = ui, server = server)

}

}
}
\seealso{
\link{updateSliderTextInput} to update value server-side.
}
