% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcrPlate-input.R
\name{updatePcrPlateInput}
\alias{updatePcrPlateInput}
\title{Change the value of a PCR plate input control on the client}
\usage{
updatePcrPlateInput(session, inputId, label = NULL, selection = NULL,
  highlighting = NULL)
}
\arguments{
\item{session}{The \code{session} object passed to function given to \code{shinyServer}.}

\item{inputId}{The id of the \code{input} object.}

\item{label}{The label to set for the input object.}

\item{selection}{The positions of the wells to be selected.}

\item{highlighting}{The positions of the wells to be highlighted.}
}
\description{
Change the value of a PCR plate input control on the client
}
\examples{
## Only run examples in interactive R sessions
library(RDML)
if (interactive()) {
ui <- fluidPage(
    pcrPlateInput("plate1",
                   "Plate 1",
                   RDML$new(system.file("/extdata/stepone_std.rdml", package = "RDML"))$AsTable(),
                  pcrFormatType$new(8,12,labelFormatType$new("ABC"),
                                         labelFormatType$new("123"))),
   verbatimTextOutput("selected"),
   actionButton("selectWellBtn",
                "Select Well A01-A03")
 )
 server <- function(input, output, session) {
   output$selected <- renderText({ input$plate1 })

   observeEvent(
               input$selectWellBtn,
               {
           updatePcrPlateInput(session,
           "plate1",
           selection = c("A01", "A02", "A03"))
  })
 }
 shinyApp(ui, server)
}
}
\author{
Konstantin A. Blagodatskikh <k.blag@yandex.ru>
}
\keyword{Input}
\keyword{PCR}
\keyword{RDML}
\keyword{Shiny}
