% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Preloader.R
\name{showF7Preloader}
\alias{showF7Preloader}
\alias{updateF7Preloader}
\alias{hideF7Preloader}
\title{Framework7 preloader}
\usage{
showF7Preloader(
  target = NULL,
  color = NULL,
  type = NULL,
  id = NULL,
  session = shiny::getDefaultReactiveDomain()
)

updateF7Preloader(
  id,
  title = NULL,
  text = NULL,
  progress = NULL,
  session = shiny::getDefaultReactiveDomain()
)

hideF7Preloader(
  target = NULL,
  id = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{target}{Element where preloader overlay will be added.}

\item{color}{Preloader color.}

\item{type}{Leave NULL to use the default preloader
or use either "dialog" or "progress".}

\item{id}{When type isn't NULL, an id is required
to be able to use \link{updateF7Preloader}.}

\item{session}{Shiny session object.}

\item{title}{Dialog title.}

\item{text}{Dialog text.}

\item{progress}{Progress bar content.}
}
\description{
\code{showF7Preloader} shows a preloader.
When \code{target} is NULL, the overlay applies
to the entire view, preventing to perform any actions.
When type is not NULL, \code{target} is ignored.

\code{updateF7Preloader} updates a preloader.

\code{hideF7Preloader} hides a preloader.
}
\examples{
if (interactive()) {
  library(shiny)
  library(shinyMobile)

  # preloader in container
  shinyApp(
    ui = f7Page(
      title = "Preloader in container",
      f7SingleLayout(
        navbar = f7Navbar(
          title = "Preloader in container"
        ),
        # main content
        f7Block(
          f7Button("compute", "Compute")
        ),
        f7Block(textOutput("calc"))
      )
    ),
    server = function(input, output, session) {
      res <- reactiveVal(NULL)
      progress <- reactiveVal(NULL)
      output$calc <- renderText(res())

      observeEvent(input$compute, {
        res(NULL)
        progress(0)
        showF7Preloader(color = "red", type = "progress", id = "loader")
        for (i in seq_along(1:100)) {
          Sys.sleep(0.025)
          progress(i)
          updateF7Preloader(
            id = "loader",
            title = "Computing ...",
            text = sprintf("Done: \%s/100", progress()),
            progress = progress()
          )
        }
        res("Result!")
      })

      observeEvent(res(), {
        hideF7Preloader(id = "loader")
      })
    }
  )
}
}
