% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-inputs.R
\name{f7Password}
\alias{f7Password}
\title{Create an f7 password input}
\usage{
f7Password(inputId, label, value = "", placeholder = NULL)
}
\arguments{
\item{inputId}{The id of the input object.}

\item{label}{The label to set for the input object.}

\item{value}{The value to set for the input object.}

\item{placeholder}{The placeholder to set for the input object.}
}
\description{
Create an f7 password input
}
\examples{
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shinyApp(
   ui = f7Page(
     title = "My app",
     f7SingleLayout(
      navbar = f7Navbar(title = "f7Password"),
      f7Password(
       inputId = "password",
       label = "Password:",
       placeholder = "Your password here"
      ),
      verbatimTextOutput("value")
     )
   ),
   server = function(input, output) {
     output$value <- renderPrint({ input$password })
   }
 )
}
}
