% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Sheet.R
\name{f7Sheet}
\alias{f7Sheet}
\alias{updateF7Sheet}
\title{Create an f7 sheet modal}
\usage{
f7Sheet(
  ...,
  hiddenItems = NULL,
  id,
  orientation = c("top", "bottom"),
  swipeToClose = FALSE,
  swipeToStep = FALSE,
  backdrop = FALSE,
  closeByOutsideClick = TRUE,
  swipeHandler = TRUE
)

updateF7Sheet(inputId, session)
}
\arguments{
\item{...}{Sheet content. If wipeToStep is TRUE, these items will be visible at start.}

\item{hiddenItems}{Put items you want to hide inside. Only works when
swipeToStep is TRUE. Default to NULL.}

\item{id}{Sheet unique id.}

\item{orientation}{"top" or "bottom".}

\item{swipeToClose}{If TRUE, it can be closed by swiping down.}

\item{swipeToStep}{If TRUE then sheet will be opened partially,
and with swipe it can be further expanded.}

\item{backdrop}{Enables Sheet backdrop (dark semi transparent layer
behind). By default it is TRUE for MD and Aurora themes and
FALSE for iOS theme.}

\item{closeByOutsideClick}{When enabled, sheet will be closed on
when click outside of it.}

\item{swipeHandler}{Whether to display a swipe handler. TRUE by default.
Need either swipeToClose or swipeToStep set to TRUE to work.}

\item{inputId}{Sheet id.}

\item{session}{Shiny session object}
}
\description{
Create an f7 sheet modal

update a framework 7 sheet modal
}
\note{
The sheet modal has to be used in combination with \link{updateF7Sheet}.
Yet, if you need a specific trigger, simply add \code{`data-sheet` = paste0("#", id)},
to the tag of your choice (a button), where id refers to the sheet unique id.
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)
 shiny::shinyApp(
    ui = f7Page(
       color = "pink",
       title = "My app",
       f7SingleLayout(
          navbar = f7Navbar(title = "f7Sheet"),
          f7Button(inputId = "go", label = "Go"),
          f7Sheet(
             id = "sheet1",
             label = "More",
             orientation = "bottom",
             swipeToClose = TRUE,
             swipeToStep = TRUE,
             backdrop = TRUE,
             "Lorem ipsum dolor sit amet, consectetur adipiscing elit.
             Quisque ac diam ac quam euismod porta vel a nunc. Quisque sodales
             scelerisque est, at porta justo cursus ac",
             hiddenItems = tagList(
                f7Segment(
                   container = "segment",
                   rounded = TRUE,
                   f7Button(color = "blue", label = "My button 1", rounded = TRUE),
                   f7Button(color = "green", label = "My button 2", rounded = TRUE),
                   f7Button(color = "yellow", label = "My button 3", rounded = TRUE)
                ),
                f7Flex(
                   f7Gauge(
                      id = "mygauge",
                      type  = "semicircle",
                      value = 10,
                      borderColor = "#2196f3",
                      borderWidth = 10,
                      valueFontSize = 41,
                      valueTextColor = "#2196f3",
                      labelText = "amount of something"
                   )
                ),
                f7Slider(
                   inputId = "obs",
                   label = "Number of observations",
                   max = 100,
                   min = 0,
                   value = 10,
                   scale = TRUE
                ),
                plotOutput("distPlot")
             )
          )
       )
    ),
    server = function(input, output, session) {
       observe({print(input$sheet1)})
       output$distPlot <- renderPlot({
          hist(rnorm(input$obs))
       })
       observeEvent(input$obs, {
          updateF7Gauge(session, id = "mygauge", value = input$obs)
       })
       observeEvent(input$go, {
          updateF7Sheet(inputId = "sheet1", session = session)
       })
    }
 )
}
}
