% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-inputs.R
\name{f7Stepper}
\alias{f7Stepper}
\title{Create a F7 radio stepper}
\usage{
f7Stepper(
  inputId,
  label,
  min,
  max,
  value,
  step = 1,
  fill = FALSE,
  rounded = FALSE,
  raised = FALSE,
  size = NULL,
  color = NULL,
  wraps = FALSE,
  autorepeat = TRUE,
  manual = TRUE
)
}
\arguments{
\item{inputId}{Stepper input id.}

\item{label}{Stepper label.}

\item{min}{Stepper minimum value.}

\item{max}{Stepper maximum value.}

\item{value}{Stepper value. Must belong to \code{\[min, max\]}.}

\item{step}{Increment step. 1 by default.}

\item{fill}{Whether to fill the stepper. FALSE by default.}

\item{rounded}{Whether to round the stepper. FALSE by default.}

\item{raised}{Whether to put a relied around the stepper. FALSE by default.}

\item{size}{Stepper size: "small", "large" or NULL.}

\item{color}{Stepper color: NULL or "red", "green", "blue", "pink", "yellow", "orange", "grey" and "black".}

\item{wraps}{In wraps mode incrementing beyond maximum value sets value to minimum value,
likewise, decrementing below minimum value sets value to maximum value. FALSE by default.}

\item{autorepeat}{Pressing and holding one of its buttons increments or decrements the stepper’s
value repeatedly. With dynamic autorepeat, the rate of change depends on how long the user
continues pressing the control. TRUE by default.}

\item{manual}{It is possible to enter value manually from keyboard or mobile keypad. When click on
input field, stepper enter into manual input mode, which allow type value from keyboar and check
fractional part with defined accurancy. Click outside or enter Return key, ending manual mode.
TRUE by default.}
}
\description{
Create a F7 radio stepper
}
\note{
Note that wrap, autorepeat and manual do not work.
}
\examples{
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shiny::shinyApp(
   ui = f7Page(
    title = "My app",
    f7SingleLayout(
     navbar = f7Navbar(title = "f7Stepper"),
     f7Stepper(
      inputId = "stepper",
      label = "My stepper",
      min = 0,
      max = 10,
      value = 4
     ),
     verbatimTextOutput("test"),
     f7Stepper(
      inputId = "stepper2",
      label = "My stepper 2",
      min = 0,
      max = 10,
      value = 4,
      color = "orange",
      raised = TRUE,
      fill = TRUE,
      rounded = TRUE
     ),
     verbatimTextOutput("test2")
    )
   ),
   server = function(input, output) {
    output$test <- renderPrint(input$stepper)
    output$test2 <- renderPrint(input$stepper2)
   }
 )
}
}
