% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny_hugeplot.R
\name{shiny_hugeplot}
\alias{shiny_hugeplot}
\alias{shiny_hugeplot.default}
\alias{shiny_hugeplot.nanotime}
\alias{shiny_hugeplot.matrix}
\alias{shiny_hugeplot.data.frame}
\alias{shiny_hugeplot.plotly}
\title{Wrapper for plot huge data in shiny and plotly}
\usage{
shiny_hugeplot(obj, ...)

\method{shiny_hugeplot}{default}(
  obj = NULL,
  y = NULL,
  n_out = 1000L,
  aggregator = eLTTB_aggregator,
  run_shiny = TRUE,
  downsampler_options = list(),
  plotly_options = list(type = "scatter", mode = "lines+markers"),
  plotly_layout_options = list(),
  shiny_options = list(),
  ...
)

\method{shiny_hugeplot}{nanotime}(
  obj = NULL,
  y = NULL,
  tz = Sys.timezone(),
  n_out = 1000L,
  aggregator = eLTTB_aggregator,
  run_shiny = TRUE,
  downsampler_options = list(),
  plotly_options = list(type = "scatter", mode = "lines+markers"),
  plotly_layout_options = list(xaxis = list(type = "date")),
  shiny_options = list(),
  ...
)

\method{shiny_hugeplot}{matrix}(
  obj = NULL,
  n_out = 1000L,
  aggregator = eLTTB_aggregator,
  run_shiny = TRUE,
  downsampler_options = list(),
  plotly_options = list(type = "scatter", mode = "lines+markers"),
  plotly_layout_options = list(),
  shiny_options = list(),
  ...
)

\method{shiny_hugeplot}{data.frame}(
  obj = NULL,
  tz = Sys.timezone(),
  n_out = 1000L,
  aggregator = eLTTB_aggregator,
  run_shiny = TRUE,
  downsampler_options = list(),
  plotly_options = list(type = "scatter", mode = "lines+markers"),
  plotly_layout_options = list(),
  shiny_options = list(),
  ...
)

\method{shiny_hugeplot}{plotly}(
  obj,
  n_out = 1000L,
  aggregator = eLTTB_aggregator,
  run_shiny = TRUE,
  downsampler_options = list(),
  shiny_options = list(),
  ...
)
}
\arguments{
\item{obj}{Numeric vector, nanotime vector, numeric matrix, data.frame,
or plotly object.
If a numeric vector is given, it is used as the y values of the figure.
the x values are calculated by \code{seq_along(obj)}.
If you use \code{y} argument together, this argument is interpreted as
the x values.
If a nanotime vector is given, it is used as the x values of the figure.
You must also give \code{y} argument, used as the y values.
Regarding \code{nanotime}, see the \code{nanotime} package.
If a numeric matrix is given, the first and second column values are used
as the x and y values. The matrix must have more than 2 columns.
If a data.frame is given, \code{d$x} and \code{d$y} are used as the
x and y values. If the class of the \code{d$x} is \code{nanotime},
the time-scale x axis is applied. The data.frame must have columns named
x and y.
If a plotly object is given, it will be displayed as the figure.}

\item{...}{Not used.}

\item{y}{Numeric vector, optional.
The y values of the figure.}

\item{n_out}{Integer, optional.
Number of samples get by the down-sampling. By default, 1000.}

\item{aggregator}{R6 class for the aggregation, optional.
Select one out of
\code{LTTB_aggregator}, \code{min_max_ovlp_aggregator},
\code{min_max_aggregator}, \code{eLTTB_aggregator},
\code{nth_pnt_aggregator}, \code{custom_stat_aggregator},
\code{mean_aggregator}, \code{median_aggregator},
\code{min_aggregator}, \code{max_aggregator},
or \code{custom_func_aggregator}.
By default \code{eLTTB_aggregator}.}

\item{run_shiny}{Boolean, optional.
whether a generated shiny app will be run immediately.
By default, \code{TRUE}.}

\item{downsampler_options}{Named list, optional.
Arguments passed to \code{shiny_downsampler$new} or the constructor of
the specific aggregator.
To set \code{aggregator} and \code{n_shown_samples},
use \code{aggregator} and \code{n_out} arguments.}

\item{plotly_options}{Named list, optional.
Arguments passed to \code{plotly::plot_ly}.}

\item{plotly_layout_options}{Named list, optional.
Arguments passed to \code{plotly::layout}.}

\item{shiny_options}{Named list, optional.
Arguments passed to \code{shinyApp} function.}

\item{tz}{Timezone, optional.
It is used to convert the nanotime to the time displayed in the figure.
By default, \code{Sys.timezone()}.}
}
\description{
This function is an easy wrapper to plot the huge data.
It employs an R6 \code{shiny_downsampler} instance to obtain samples
from data using a specified aggregation method.
The figure will be updated interactively according to the x-range
that user can define manually in the shiny app.
}
\examples{
\donttest{
data(noise_fluct)

shiny_hugeplot(noise_fluct$level)
shiny_hugeplot(
  noise_fluct$t, noise_fluct$level,
  plotly_layout_options = list(xaxis = list(type = "date"))
)
}
}
