% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregators.R
\docType{class}
\name{LTTB_aggregator}
\alias{LTTB_aggregator}
\title{Aggregation using Largest Triangle Three Buckets (LTTB) method.}
\format{
An \code{R6::R6Class} object
}
\description{
The LTTB method aggregates the huge samples using the areas
of the triangles formed by the samples.
Numerical distances are employed in this class,
which requires the ratio between x and y values.
When the x is datetime, nanosecond is a unit.
When the x is factor or character, it will be encoded into numeric codes.
}
\examples{
data(noise_fluct)
agg <- LTTB_aggregator$new()
d_agg <- agg$aggregate(noise_fluct$sec, noise_fluct$level, 1000)
plot(d_agg$x, d_agg$y, type = "l")
}
\section{Super class}{
\code{\link[shinyHugePlot:abstract_aggregator]{shinyHugePlot::abstract_aggregator}} -> \code{LTTB_aggregator}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LTTB_aggregator-new}{\code{LTTB_aggregator$new()}}
\item \href{#method-LTTB_aggregator-clone}{\code{LTTB_aggregator$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="abstract_aggregator" data-id="aggregate"><a href='../../shinyHugePlot/html/abstract_aggregator.html#method-abstract_aggregator-aggregate'><code>shinyHugePlot::abstract_aggregator$aggregate()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LTTB_aggregator-new"></a>}}
\if{latex}{\out{\hypertarget{method-LTTB_aggregator-new}{}}}
\subsection{Method \code{new()}}{
Constructor of the Aggregator.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LTTB_aggregator$new(
  interleave_gaps = FALSE,
  nan_position = "end",
  nt_y_ratio = 1e+09,
  x_y_ratio = 1
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{interleave_gaps, nan_position}}{Arguments pass to the constructor of
the \code{abstract_aggregator} class.}

\item{\code{x_y_ratio, nt_y_ratio}}{Numeric.
These parameters set the unit length of the numeric \code{x}
and \code{nanotime} x.
For example, setting \code{x_y_ratio} to 2 is equivalent to
assuming 2 is the unit length of \code{x}
(and 1 is always the unit length of \code{y}).
The unit length is employed to calculate the area of the triangles.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LTTB_aggregator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LTTB_aggregator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LTTB_aggregator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
