% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accordion.R
\name{accordion}
\alias{accordion}
\title{Create simple accordion}
\usage{
accordion(id, ..., class = "")
}
\arguments{
\item{id}{Id of the accordion component.}

\item{...}{Accordion items created with \link{accordionItem}.}

\item{class}{Extra class added to accordion container.}
}
\value{
A `shiny.tag` object defining html structure of accordion container.
}
\description{
Created component provides basic accordion functionality - enroll/collapse behavior
with only necessary styling (enrolled state icon).
In order to provide custom styling for accordion items configure its header and content accordingly
while constructing the item (see \link{accordionItem}).
}
\examples{
# Basic construction with simple header and content
if (interactive()) {
  library(shiny)
  ui <- fluidPage(
    actionButton("new", "New"),
    accordion(
      "acc",
      accordionItem("first", "Hello", "There", active = TRUE),
      accordionItem("second", "General", "Kenobi")
    )
  )

  server <- function(input, output, session) {
    observeEvent(input$new, {
      addAccordionItem("acc", accordionItem(sample(letters, 1), "New", "Accordion", active = TRUE))
    })
  }

  shinyApp(ui, server)
}

}
