% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_started_done.R
\name{log_started}
\alias{log_started}
\alias{log_done}
\title{Logging the start of an event}
\usage{
log_started(..., name = NULL, type = "EVENT", status = "STARTED",
  params = NULL)

log_done(..., name = NULL, params = NULL)
}
\arguments{
\item{...}{Objects that are evaluated, coerced into character string,
collapsed and pasted into log entry body
(or header if \code{name} is \code{NULL}).}

\item{name}{A character string. The name of the event.}

\item{type}{A character string. A type of the event.
Default for \code{log_started} is \code{"EVENT"}.
The \code{type} logged with \code{log_done} is the same as
the \code{type} of the event logged with \code{log_started}.}

\item{status}{A character string. A status of the event.
Default for \code{log_started} is \code{"STARTED"}.
The \code{status} is always \code{"DONE"} when using \code{log_done}.}

\item{params}{A list of additional named event-specific parameters.
Default is \code{NULL}.}
}
\description{
\code{log_started} logs an event with status \code{"STARTED"}.
\code{log_done} logs the same event with status \code{"DONE"}.
Difference between timestamps of these two log entries can be used
for timing an event. One event can have several instances with
different statuses.
When logging instances of the same event, event \code{name}
or, if \code{name = NULL}, objects passed to \code{...}
must be exactly the same, as they are used to create unique event id.
Started events, their types and counters are registered
in an environment called \code{log_event_register},
which enables creating and timing multiple nested events.
}
\section{Functions}{
\itemize{
\item \code{log_started}: Logging the start of an event

\item \code{log_done}: Logging the end of an event
}}

\examples{
if (interactive()) {
  set_logging()
  shiny::shinyApp(
    ui = shiny::fluidPage(log_init()),
    server = function(input, output) {
      set_logging_session()
        log_started(as.character(Sys.time()), name = "Event 1")
        Sys.sleep(0.5)
          log_started(as.character(Sys.time()), name = "Event 2")
            log_event(as.character(Sys.time()), name = "Event 3")
            Sys.sleep(0.5)
          log_done(as.character(Sys.time()), name = "Event 2")
        log_done(as.character(Sys.time()), name = "Event 1")
    }
  )
}
}
\seealso{
Other logging events functions: \code{\link{log_event}},
  \code{\link{log_message}}, \code{\link{log_output}},
  \code{\link{log_test}}, \code{\link{log_value}}
}
\concept{logging events functions}
