% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chakraSlider.R
\name{chakraRangeSlider}
\alias{chakraRangeSlider}
\title{Chakra range slider}
\usage{
chakraRangeSlider(
  id,
  label = NULL,
  values,
  min,
  max,
  step = NULL,
  width = NULL,
  size = "md",
  colorScheme = "blue",
  orientation = "horizontal",
  focusThumbOnChange = TRUE,
  isDisabled = FALSE,
  isReadOnly = FALSE,
  isReversed = FALSE,
  trackColor = NULL,
  filledTrackColor = NULL,
  tooltip = TRUE,
  tooltipOptions = sliderTooltipOptions(),
  thumbOptionsLeft = sliderThumbOptions(),
  thumbOptionsRight = sliderThumbOptions(),
  shinyValueOn = "end",
  ...
)
}
\arguments{
\item{id}{widget id}

\item{label}{label (optional)}

\item{values}{the two initial values}

\item{min}{minimal value}

\item{max}{maximal value}

\item{step}{increment step}

\item{width}{slider width}

\item{size}{size, \code{"sm"}, \code{"md"}, or \code{"lg"}}

\item{colorScheme}{a Chakra color scheme}

\item{orientation}{slider orientation, \code{"horizontal"} or
\code{"vertical"}}

\item{focusThumbOnChange}{whether to focus the thumb on change}

\item{isDisabled}{whether to disable the slider}

\item{isReadOnly}{read only mode}

\item{isReversed}{whether to reverse the slider}

\item{trackColor}{color of the track}

\item{filledTrackColor}{color of the filled track}

\item{tooltip}{whether to set a tooltip to the thumb}

\item{tooltipOptions}{options of the tooltip, a list created with
\code{\link{sliderTooltipOptions}}}

\item{thumbOptionsLeft}{list of options for the left thumb, created with
\code{\link{sliderThumbOptions}}}

\item{thumbOptionsRight}{list of options for the right thumb, created with
\code{\link{sliderThumbOptions}}}

\item{shinyValueOn}{either \code{"drag"} or \code{"end"}, the moment to get
the Shiny value}

\item{...}{other attributes passed to \code{RangeSlider}}
}
\value{
A widget to use in \code{\link{chakraComponent}}.
}
\description{
Create a Chakra range slider.
}
\examples{
# Run `chakraExample("RangeSlider")` to see a better example.
library(shiny)
library(shinyChakraUI)

ui <- chakraPage(

  br(),

  chakraComponent(
    "mycomponent",

    chakraRangeSlider(
      "slider",
      label = HTML("<span style='color:red'>Hello range slider!</span>"),
      values = c(2, 8),
      min = 0,
      max = 10,
      width = "50\%",
      tooltip = TRUE,
      tooltipOptions = sliderTooltipOptions(placement = "bottom"),
      shinyValueOn = "end"
    )

  )

)

server <- function(input, output, session){

  observe({
    print(input[["slider"]])
  })

}

if(interactive()){
  shinyApp(ui, server)
}
}
