% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imageutils.R
\name{plotPNG}
\alias{plotPNG}
\title{Capture a plot as a PNG file.}
\usage{
plotPNG(
  func,
  filename = tempfile(fileext = ".png"),
  width = 400,
  height = 400,
  res = 72,
  ...
)
}
\arguments{
\item{func}{A function that generates a plot.}

\item{filename}{The name of the output file. Defaults to a temp file with
extension \code{.png}.}

\item{width}{Width in pixels.}

\item{height}{Height in pixels.}

\item{res}{Resolution in pixels per inch. This value is passed to the
graphics device. Note that this affects the resolution of PNG rendering in
R; it won't change the actual ppi of the browser.}

\item{...}{Arguments to be passed through to the graphics device. These can
be used to set the width, height, background color, etc.}
}
\value{
A path to the newly generated PNG file.
}
\description{
The PNG graphics device used is determined in the following order:
\itemize{
\item If the ragg package is installed (and the \code{shiny.useragg} is not
set to \code{FALSE}), then use \code{\link[ragg:agg_png]{ragg::agg_png()}}.
\item If a quartz device is available (i.e., \code{capabilities("aqua")} is
\code{TRUE}), then use \code{png(type = "quartz")}.
\item If the Cairo package is installed (and the \code{shiny.usecairo} option
is not set to \code{FALSE}), then use \code{\link[Cairo:Cairo]{Cairo::CairoPNG()}}.
\item Otherwise, use \code{\link[grDevices:png]{grDevices::png()}}. In this case, Linux and Windows
may not antialias some point shapes, resulting in poor quality output.
}
}
