% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{diskCache}
\alias{diskCache}
\title{Create disk cache (deprecated)}
\usage{
diskCache(
  dir = NULL,
  max_size = 500 * 1024^2,
  max_age = Inf,
  max_n = Inf,
  evict = c("lru", "fifo"),
  destroy_on_finalize = FALSE,
  missing = key_missing(),
  exec_missing = deprecated(),
  logfile = NULL
)
}
\arguments{
\item{dir}{Directory to store files for the cache. If \code{NULL} (the default) it
will create and use a temporary directory.}

\item{max_size}{Maximum size of the cache, in bytes. If the cache exceeds
this size, cached objects will be removed according to the value of the
\code{evict}. Use \code{Inf} for no size limit. The default is 1 gigabyte.}

\item{max_age}{Maximum age of files in cache before they are evicted, in
seconds. Use \code{Inf} for no age limit.}

\item{max_n}{Maximum number of objects in the cache. If the number of objects
exceeds this value, then cached objects will be removed according to the
value of \code{evict}. Use \code{Inf} for no limit of number of items.}

\item{evict}{The eviction policy to use to decide which objects are removed
when a cache pruning occurs. Currently, \code{"lru"} and \code{"fifo"} are supported.}

\item{destroy_on_finalize}{If \code{TRUE}, then when the cache_disk object is
garbage collected, the cache directory and all objects inside of it will be
deleted from disk. If \code{FALSE} (the default), it will do nothing when
finalized.}

\item{missing}{A value to return when \code{get(key)} is called but the key is not
present in the cache. The default is a \code{\link[cachem:key_missing]{key_missing()}} object. It is
actually an expression that is evaluated each time there is a cache miss.
See section Missing keys for more information.}

\item{exec_missing}{Deprecated.}

\item{logfile}{An optional filename or connection object to where logging
information will be written. To log to the console, use \code{stderr()} or
\code{stdout()}.}
}
\description{
Create disk cache (deprecated)
}
\keyword{internal}
