% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-date.R
\name{dateInput}
\alias{dateInput}
\title{Create date input}
\usage{
dateInput(inputId, label, value = NULL, min = NULL, max = NULL,
  format = "yyyy-mm-dd", startview = "month", weekstart = 0,
  language = "en", width = NULL)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{value}{The starting date. Either a Date object, or a string in
\code{yyyy-mm-dd} format. If NULL (the default), will use the current date
in the client's time zone.}

\item{min}{The minimum allowed date. Either a Date object, or a string in
\code{yyyy-mm-dd} format.}

\item{max}{The maximum allowed date. Either a Date object, or a string in
\code{yyyy-mm-dd} format.}

\item{format}{The format of the date to display in the browser. Defaults to
\code{"yyyy-mm-dd"}.}

\item{startview}{The date range shown when the input object is first clicked.
Can be "month" (the default), "year", or "decade".}

\item{weekstart}{Which day is the start of the week. Should be an integer
from 0 (Sunday) to 6 (Saturday).}

\item{language}{The language used for month and day names. Default is "en".
Other valid values include "ar", "az", "bg", "bs", "ca", "cs", "cy", "da",
"de", "el", "en-AU", "en-GB", "eo", "es", "et", "eu", "fa", "fi", "fo",
"fr-CH", "fr", "gl", "he", "hr", "hu", "hy", "id", "is", "it-CH", "it",
"ja", "ka", "kh", "kk", "ko", "kr", "lt", "lv", "me", "mk", "mn", "ms",
"nb", "nl-BE", "nl", "no", "pl", "pt-BR", "pt", "ro", "rs-latin", "rs",
"ru", "sk", "sl", "sq", "sr-latin", "sr", "sv", "sw", "th", "tr", "uk",
"vi", "zh-CN", and "zh-TW".}

\item{width}{The width of the input, e.g. \code{'400px'}, or \code{'100\%'};
see \code{\link{validateCssUnit}}.}
}
\description{
Creates a text input which, when clicked on, brings up a calendar that
the user can click on to select dates.
}
\details{
The date \code{format} string specifies how the date will be displayed in
the browser. It allows the following values:

\itemize{
  \item \code{yy} Year without century (12)
  \item \code{yyyy} Year with century (2012)
  \item \code{mm} Month number, with leading zero (01-12)
  \item \code{m} Month number, without leading zero (01-12)
  \item \code{M} Abbreviated month name
  \item \code{MM} Full month name
  \item \code{dd} Day of month with leading zero
  \item \code{d} Day of month without leading zero
  \item \code{D} Abbreviated weekday name
  \item \code{DD} Full weekday name
}
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

ui <- fluidPage(
  dateInput("date1", "Date:", value = "2012-02-29"),

  # Default value is the date in client's time zone
  dateInput("date2", "Date:"),

  # value is always yyyy-mm-dd, even if the display format is different
  dateInput("date3", "Date:", value = "2012-02-29", format = "mm/dd/yy"),

  # Pass in a Date object
  dateInput("date4", "Date:", value = Sys.Date()-10),

  # Use different language and different first day of week
  dateInput("date5", "Date:",
          language = "ru",
          weekstart = 1),

  # Start with decade view instead of default month view
  dateInput("date6", "Date:",
            startview = "decade")
)

shinyApp(ui, server = function(input, output) { })
}
}
\seealso{
\code{\link{dateRangeInput}}, \code{\link{updateDateInput}}

Other input.elements: \code{\link{actionButton}},
  \code{\link{checkboxGroupInput}},
  \code{\link{checkboxInput}},
  \code{\link{dateRangeInput}}, \code{\link{fileInput}},
  \code{\link{numericInput}}, \code{\link{passwordInput}},
  \code{\link{radioButtons}}, \code{\link{selectInput}},
  \code{\link{sliderInput}}, \code{\link{submitButton}},
  \code{\link{textAreaInput}}, \code{\link{textInput}}
}

