% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/shiny.R
\name{shiny-options}
\alias{shiny-options}
\title{Global options for Shiny}
\description{
There are a number of global options that affect Shiny's behavior. These can
be set with (for example) \code{options(shiny.trace=TRUE)}.
}
\details{
\describe{
  \item{shiny.launch.browser}{A boolean which controls the default behavior
    when an app is run. See \code{\link{runApp}} for more information.}
  \item{shiny.trace}{If \code{TRUE}, all of the messages sent between the R
    server and the web browser client will be printed on the console. This
    is useful for debugging.}
  \item{shiny.reactlog}{If \code{TRUE}, enable logging of reactive events,
    which can be viewed later with the \code{\link{showReactLog}} function.
    This incurs a substantial performance penalty and should not be used in
    production.}
  \item{shiny.usecairo}{This is used to disable graphical rendering by the
    Cairo package, if it is installed. See \code{\link{plotPNG}} for more
    information.}
  \item{shiny.maxRequestSize}{This is a number which specifies the maximum
    web request size, which serves as a size limit for file uploads. If
    unset, the maximum request size defaults to 5MB.}
  \item{shiny.suppressMissingContextError}{Normally, invoking a reactive
    outside of a reactive context (or \code{\link{isolate}()}) results in
    an error. If this is \code{TRUE}, don't error in these cases. This
    should only be used for debugging or demonstrations of reactivity at the
    console.}
  \item{shiny.host}{The IP address that Shiny should listen on. See
    \code{\link{runApp}} for more information.}
  \item{shiny.json.digits}{The number of digits to use when converting
    numbers to JSON format to send to the client web browser.}
  \item{shiny.error}{This can be a function which is called when an error
    occurs. For example, \code{options(shiny.error=recover)} will result a
    the debugger prompt when an error occurs.}
  \item{shiny.observer.error}{This can be a function that is called by an
    observer when an unhandled error occurs in it or an upstream reactive.
    By default, these errors will result in a warning at the console, and
    the websocket connection will close.}
  \item{shiny.table.class}{CSS class names to use for tables.}
  \item{shiny.deprecation.messages}{This controls whether messages for
    deprecated functions in Shiny will be printed. See
    \code{\link{shinyDeprecated}} for more information.}
}
}

