% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-storage-plumber.R
\name{DataStoragePlumber}
\alias{DataStoragePlumber}
\title{Data storage class with SQLite provider}
\description{
Implementation of the \code{\link{DataStorage}} R6 class to SQLite backend using a unified
API for read/write operations
}
\examples{
\dontrun{
# Make sure the PLUMBER_SECRET environment variable is valid before
# running these examples (NULL or a valid secret)

data_storage <- DataStoragePlumber$new(
  hostname = "connect.appsilon.com",
  path = "shiny_telemetry_plumber",
  port = 443,
  protocol = "https",
  authorization = Sys.getenv("CONNECT_AUTHORIZATION_KEY"),
  secret = Sys.getenv("PLUMBER_SECRET")
)

data_storage <- DataStoragePlumber$new(
  hostname = "127.0.0.1",
  path = NULL,
  port = 8087,
  protocol = "http",
  secret = Sys.getenv("PLUMBER_SECRET")
)

data_storage$insert("example", "test_event", "session1")
data_storage$insert("example", "input", "s1", list(id = "id"))
data_storage$insert("example", "input", "s1", list(id = "id2", value = 32))

data_storage$insert(
  "example", "test_event_3_days_ago", "session1",
  time = lubridate::as_datetime(lubridate::today() - 3)
)

data_storage$read_event_data()
data_storage$read_event_data(Sys.Date() - 1, Sys.Date() + 1)
}
}
\section{Super class}{
\code{\link[shiny.telemetry:DataStorage]{shiny.telemetry::DataStorage}} -> \code{DataStoragePlumber}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{event_read_endpoint}}{string field that returns read action
endpoint}

\item{\code{event_insert_endpoint}}{string field that returns insert action
endpoint}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DataStoragePlumber-new}{\code{DataStoragePlumber$new()}}
\item \href{#method-DataStoragePlumber-clone}{\code{DataStoragePlumber$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="shiny.telemetry" data-topic="DataStorage" data-id="close"><a href='../../shiny.telemetry/html/DataStorage.html#method-DataStorage-close'><code>shiny.telemetry::DataStorage$close()</code></a></span></li>
<li><span class="pkg-link" data-pkg="shiny.telemetry" data-topic="DataStorage" data-id="insert"><a href='../../shiny.telemetry/html/DataStorage.html#method-DataStorage-insert'><code>shiny.telemetry::DataStorage$insert()</code></a></span></li>
<li><span class="pkg-link" data-pkg="shiny.telemetry" data-topic="DataStorage" data-id="read_event_data"><a href='../../shiny.telemetry/html/DataStorage.html#method-DataStorage-read_event_data'><code>shiny.telemetry::DataStorage$read_event_data()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataStoragePlumber-new"></a>}}
\if{latex}{\out{\hypertarget{method-DataStoragePlumber-new}{}}}
\subsection{Method \code{new()}}{
Initialize the data storage class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataStoragePlumber$new(
  hostname = "127.0.0.1",
  port = 80,
  protocol = "http",
  path = NULL,
  secret = NULL,
  authorization = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{hostname}}{string with hostname of plumber instance,}

\item{\code{port}}{numeric value with port number of plumber instance.}

\item{\code{protocol}}{string with protocol of the connection of the plumber
instance.}

\item{\code{path}}{string with sub-path of plumber deployment.}

\item{\code{secret}}{string with secret to sign communication with plumber (can
be NULL for disabling communication signing).}

\item{\code{authorization}}{string to use in HTTP headers for authorization
(for example: to authenticate to a plumber deployment behind a connect
server).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataStoragePlumber-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DataStoragePlumber-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataStoragePlumber$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
