% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/telemetry.R
\name{Telemetry}
\alias{Telemetry}
\title{Telemetry class to manage analytics gathering at a global level}
\description{
An instance of this class will define metadata and data storage provider
for gathering telemetry analytics of a Shiny dashboard.


The `name` and `version` parameters will describe the dashboard name and
version to track using analytics, allowing to store the analytics data from
multiple dashboards in the same data storage provider. As well as
discriminate different versions of the dashboard.


The default data storage provider uses a local SQLite database, but this
can be customizable when instantiating the class, by using another one of
the supported providers (see [DataStorage]).
}
\examples{
log_file_path <- tempfile(fileext = ".txt")
telemetry <- Telemetry$new(
  data_storage = DataStorageLogFile$new(log_file_path = log_file_path)
)

#
# Create dummy session (only for example purposes)
session <- shiny::MockShinySession$new()
class(session) <- c(class(session), "ShinySession")

telemetry$start_session(session = session)

telemetry$log_click("a_button", session = session)

telemetry$log_custom_event("a_button", list(value = 2023), session = session)
telemetry$log_custom_event("a_button", list(custom_field = 23), session = session)

# Manual call loging with custom username
telemetry$log_login("ben", session = session)

telemetry$data_storage$read_event_data("2020-01-01", "2025-01-01")

file.remove(log_file_path)

#
# Using SQLite

db_path <- tempfile(fileext = ".sqlite")
telemetry <- Telemetry$new(
  data_storage = DataStorageSQLite$new(db_path = db_path)
)

telemetry$log_custom_event("a_button", list(value = 2023), session = session)
telemetry$log_custom_event("a_button", list(custom_field = 23), session = session)

telemetry$data_storage$read_event_data("2020-01-01", "2025-01-01")

file.remove(db_path)
}
\seealso{
[shiny.telemetry::DataStorage] which this function wraps.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{data_storage}}{instance of a class that inherits from
[DataStorage]. See the documentation on that class for more information.}

\item{\code{app_name}}{string with name of dashboard}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Telemetry-new}{\code{Telemetry$new()}}
\item \href{#method-Telemetry-start_session}{\code{Telemetry$start_session()}}
\item \href{#method-Telemetry-log_navigation}{\code{Telemetry$log_navigation()}}
\item \href{#method-Telemetry-log_navigation_manual}{\code{Telemetry$log_navigation_manual()}}
\item \href{#method-Telemetry-log_login}{\code{Telemetry$log_login()}}
\item \href{#method-Telemetry-log_logout}{\code{Telemetry$log_logout()}}
\item \href{#method-Telemetry-log_click}{\code{Telemetry$log_click()}}
\item \href{#method-Telemetry-log_browser_version}{\code{Telemetry$log_browser_version()}}
\item \href{#method-Telemetry-log_button}{\code{Telemetry$log_button()}}
\item \href{#method-Telemetry-log_all_inputs}{\code{Telemetry$log_all_inputs()}}
\item \href{#method-Telemetry-log_input}{\code{Telemetry$log_input()}}
\item \href{#method-Telemetry-log_input_manual}{\code{Telemetry$log_input_manual()}}
\item \href{#method-Telemetry-log_custom_event}{\code{Telemetry$log_custom_event()}}
\item \href{#method-Telemetry-clone}{\code{Telemetry$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Telemetry-new"></a>}}
\if{latex}{\out{\hypertarget{method-Telemetry-new}{}}}
\subsection{Method \code{new()}}{
Constructor that initializes Telemetry instance with parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Telemetry$new(
  app_name = "(dashboard)",
  data_storage = DataStorageSQLite$new(db_path = file.path("telemetry.sqlite"))
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{app_name}}{(optional) string that identifies the name of the dashboard.
By default it will store data with `(dashboard)`.}

\item{\code{data_storage}}{(optional) DataStorage instance where telemetry
data is being stored.
It can take any of data storage providers by this package,
By default it will store in a SQLite local database in the current
working directory with filename `telemetry.sqlite`}

\item{\code{version}}{(optional) string that identifies the version of the
dashboard. By default it will use `v0.0.0`.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Telemetry-start_session"></a>}}
\if{latex}{\out{\hypertarget{method-Telemetry-start_session}{}}}
\subsection{Method \code{start_session()}}{
Setup basic telemetry
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Telemetry$start_session(
  track_inputs = TRUE,
  track_values = FALSE,
  login = TRUE,
  logout = TRUE,
  browser_version = TRUE,
  navigation_input_id = NULL,
  session = shiny::getDefaultReactiveDomain(),
  username = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{track_inputs}}{flag that indicates if the basic telemetry should
track the inputs that change value. `TRUE` by default}

\item{\code{track_values}}{flag that indicates if the basic telemetry should
track the values of the inputs that are changing. `FALSE` by default.
This parameter is ignored if `track_inputs` is `FALSE`}

\item{\code{login}}{flag that indicates if the basic telemetry should
track when a session starts. `TRUE` by default.}

\item{\code{logout}}{flag that indicates if the basic telemetry should
track when the session ends. `TRUE` by default.}

\item{\code{browser_version}}{flag that indicates that the browser version
should be tracked.`TRUE` by default.}

\item{\code{navigation_input_id}}{string or vector of strings that represent
input ids and which value should be tracked as navigation events. i.e.
a change in the value represent a navigation to a page or tab.
By default, no navigation is tracked.}

\item{\code{session}}{ShinySession object or NULL to identify the current
Shiny session.}

\item{\code{username}}{Character with username. If set, it will overwrite username
from session object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing. This method is called for side effects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Telemetry-log_navigation"></a>}}
\if{latex}{\out{\hypertarget{method-Telemetry-log_navigation}{}}}
\subsection{Method \code{log_navigation()}}{
Log an input change as a navigation event
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Telemetry$log_navigation(input_id, session = shiny::getDefaultReactiveDomain())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input_id}}{string that identifies the generic input in the Shiny
application so that the function can track and log changes to it.}

\item{\code{session}}{ShinySession object or NULL to identify the current
Shiny session.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing. This method is called for side effects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Telemetry-log_navigation_manual"></a>}}
\if{latex}{\out{\hypertarget{method-Telemetry-log_navigation_manual}{}}}
\subsection{Method \code{log_navigation_manual()}}{
Log a navigation event manually by indicating the id (as input id)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Telemetry$log_navigation_manual(
  navigation_id,
  value,
  session = shiny::getDefaultReactiveDomain()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{navigation_id}}{string that identifies navigation event.}

\item{\code{value}}{string that indicates a value for the navigation}

\item{\code{session}}{ShinySession object or NULL to identify the current
Shiny session.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing. This method is called for side effects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Telemetry-log_login"></a>}}
\if{latex}{\out{\hypertarget{method-Telemetry-log_login}{}}}
\subsection{Method \code{log_login()}}{
Log when session starts
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Telemetry$log_login(
  username = NULL,
  session = shiny::getDefaultReactiveDomain()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{username}}{string with username from current session}

\item{\code{session}}{ShinySession object or NULL to identify the current
Shiny session.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing. This method is called for side effects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Telemetry-log_logout"></a>}}
\if{latex}{\out{\hypertarget{method-Telemetry-log_logout}{}}}
\subsection{Method \code{log_logout()}}{
Log when session ends
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Telemetry$log_logout(
  username = NULL,
  session = shiny::getDefaultReactiveDomain()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{username}}{string with username from current session}

\item{\code{session}}{ShinySession object or NULL to identify the current
Shiny session.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing. This method is called for side effects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Telemetry-log_click"></a>}}
\if{latex}{\out{\hypertarget{method-Telemetry-log_click}{}}}
\subsection{Method \code{log_click()}}{
Log an action click
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Telemetry$log_click(id, session = shiny::getDefaultReactiveDomain())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{string that identifies a manual click to the dashboard.}

\item{\code{session}}{ShinySession object or NULL to identify the current
Shiny session.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing. This method is called for side effects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Telemetry-log_browser_version"></a>}}
\if{latex}{\out{\hypertarget{method-Telemetry-log_browser_version}{}}}
\subsection{Method \code{log_browser_version()}}{
Log the browser version
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Telemetry$log_browser_version(session = shiny::getDefaultReactiveDomain())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{session}}{ShinySession object or NULL to identify the current
Shiny session.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing. This method is called for side effects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Telemetry-log_button"></a>}}
\if{latex}{\out{\hypertarget{method-Telemetry-log_button}{}}}
\subsection{Method \code{log_button()}}{
Track a button and track changes to this input (without storing the
values)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Telemetry$log_button(
  input_id,
  track_value = FALSE,
  session = shiny::getDefaultReactiveDomain()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input_id}}{string that identifies the button in the Shiny
application so that the function can track and log changes to it.}

\item{\code{track_value}}{flag that indicates if the basic telemetry should
track the value of the input that are changing. `FALSE` by default.}

\item{\code{session}}{ShinySession object or NULL to identify the current
Shiny session.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing. This method is called for side effects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Telemetry-log_all_inputs"></a>}}
\if{latex}{\out{\hypertarget{method-Telemetry-log_all_inputs}{}}}
\subsection{Method \code{log_all_inputs()}}{
A short description...
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Telemetry$log_all_inputs(
  track_values = FALSE,
  excluded_inputs = c("browser_version"),
  session = shiny::getDefaultReactiveDomain()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{track_values}}{flag that indicates if the basic telemetry should
track the values of the inputs that are changing. `FALSE` by default.
This parameter is ignored if `track_inputs` is `FALSE`.}

\item{\code{excluded_inputs}}{vector of input_ids that should not be tracked.
By default it doesn't track browser version, which is added by this
package.}

\item{\code{session}}{ShinySession object or NULL to identify the current
Shiny session.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing. This method is called for side effects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Telemetry-log_input"></a>}}
\if{latex}{\out{\hypertarget{method-Telemetry-log_input}{}}}
\subsection{Method \code{log_input()}}{
A short description...
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Telemetry$log_input(
  input_id,
  track_value = FALSE,
  matching_values = NULL,
  input_type = "text",
  session = shiny::getDefaultReactiveDomain()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input_id}}{string that identifies the generic input in the Shiny
application so that the function can track and log changes to it.}

\item{\code{track_value}}{flag that indicates if the basic telemetry should
track the value of the input that are changing. `FALSE` by default.}

\item{\code{matching_values}}{An object specified possible values to register.}

\item{\code{input_type}}{'text' to registered bare input value, 'json' to parse
value from JSON format.}

\item{\code{session}}{ShinySession object or NULL to identify the current
Shiny session.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing. This method is called for side effects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Telemetry-log_input_manual"></a>}}
\if{latex}{\out{\hypertarget{method-Telemetry-log_input_manual}{}}}
\subsection{Method \code{log_input_manual()}}{
Log a manual input value.


This can be called in telemetry and is also used as a layer between
log_input family of functions and actual log event.
It creates the correct payload to log the event internally.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Telemetry$log_input_manual(
  input_id,
  value = NULL,
  session = shiny::getDefaultReactiveDomain()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input_id}}{string that identifies the generic input in the Shiny
application so that the function can track and log changes to it.}

\item{\code{value}}{(optional) scalar value or list with the value to register.}

\item{\code{session}}{ShinySession object or NULL to identify the current
Shiny session.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing. This method is called for side effects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Telemetry-log_custom_event"></a>}}
\if{latex}{\out{\hypertarget{method-Telemetry-log_custom_event}{}}}
\subsection{Method \code{log_custom_event()}}{
Log a manual event
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Telemetry$log_custom_event(
  event_type,
  details = NULL,
  session = shiny::getDefaultReactiveDomain()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{event_type}}{string that identifies the event type}

\item{\code{details}}{(optional) scalar value or list with the value to register.}

\item{\code{session}}{ShinySession object or NULL to identify the current
Shiny session.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing. This method is called for side effects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Telemetry-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Telemetry-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Telemetry$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
