% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/button.R
\name{button}
\alias{button}
\title{Create Semantic UI Button}
\usage{
button(input_id, label, icon = NULL, class = NULL, ...)
}
\arguments{
\item{input_id}{The \code{input} slot that will be used to access the value.}

\item{label}{The contents of the button or link}

\item{icon}{An optional \code{\link{icon}()} to appear on the button.}

\item{class}{An optional attribute to be added to the button's class. If used
paramters like \code{color}, \code{size} are ignored.}

\item{...}{Named attributes to be applied to the button}
}
\description{
Create Semantic UI Button
}
\examples{
if (interactive()){
library(shiny)
library(shiny.semantic)
ui <- semanticPage(
  shinyUI(
    button("simple_button", "Press Me!")
  )
)
server <- function(input, output, session) {
}
shinyApp(ui, server)
}


}
