% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slider.R
\name{slider_input}
\alias{slider_input}
\alias{sliderInput}
\alias{range_input}
\title{Create Semantic UI Slider / Range}
\usage{
slider_input(
  input_id,
  value,
  min,
  max,
  step = 1,
  class = "labeled",
  custom_ticks = NULL
)

sliderInput(
  inputId,
  label,
  min,
  max,
  value,
  step = 1,
  width = NULL,
  ticks = TRUE,
  ...
)

range_input(input_id, value, value2, min, max, step = 1, class = NULL)
}
\arguments{
\item{input_id}{Input name. Reactive value is available under \code{input[[input_id]]}.}

\item{value}{The initial value to be selected for the sldier (lower value if using range).}

\item{min}{The minimum value allowed to be selected for the slider.}

\item{max}{The maximum value allowed to be selected for the slider.}

\item{step}{The interval between each selectable value of the slider.}

\item{class}{UI class of the slider. Can include \code{"labeled"} and \code{"ticked"}.}

\item{custom_ticks}{A vector of custom labels to be added to the slider. Will ignore \code{min} and \code{max}}

\item{inputId}{Input name.}

\item{label}{Display label for the control, or NULL for no label.}

\item{width}{character with width of slider.}

\item{ticks}{\code{FALSE} to hide tick marks, \code{TRUE} to show them according to some simple heuristics}

\item{...}{additional arguments}

\item{value2}{The initial upper value of the slider.}
}
\description{
This creates a slider input using Semantic UI. Slider is already initialized and
available under \code{input[[input_id]]}. Use Range for range of values.
}
\details{
Use \code{\link{update_slider}} to update the slider/range within the shiny session.
}
\examples{
if (interactive()) {
  # Slider example
  library(shiny)
  library(shiny.semantic)

  ui <- shinyUI(
    semanticPage(
      title = "Slider example",
      tags$br(),
      slider_input("slider", 10, 0, 20, class = "labeled ticked"),
      p("Selected value:"),
      textOutput("slider")
    )
  )
  server <- shinyServer(function(input, output, session) {
    output$slider <- renderText(input$slider)
  })
  shinyApp(ui = ui, server = server)

  # Custom ticks slider
  ui <- shinyUI(
    semanticPage(
      title = "Slider example",
      tags$br(),
      slider_input("slider_ticks", "F", custom_ticks = LETTERS, class = "labeled ticked"),
      p("Selected value:"),
      textOutput("slider_ticks")
    )
  )
  server <- shinyServer(function(input, output, session) {
    output$slider_ticks <- renderText(input$slider_ticks)
  })
  shinyApp(ui = ui, server = server)

  # Range example
  ui <- shinyUI(
    semanticPage(
      title = "Range example",
      tags$br(),
      range_input("range", 10, 15, 0, 20),
      p("Selected values:"),
      textOutput("range")
    )
  )
  server <- shinyServer(function(input, output, session) {
    output$range <- renderText(paste(input$range, collapse = " - "))
  })
  shinyApp(ui = ui, server = server)
}

}
\seealso{
update_slider for input updates,
\url{https://fomantic-ui.com/modules/slider.html} for preset classes.
}
