% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsl.R
\name{uilist}
\alias{uilist}
\title{Create Semantic UI list with header, description and icons}
\usage{
uilist(data, icon, is_divided = FALSE, is_description = FALSE)
}
\arguments{
\item{data}{A dataframe with columns `header` and/or `description` containing the list items
headers and descriptions. `description` column is optional and should be provided
if `is_description` parameter TRUE.}

\item{icon}{A string with icon name. Empty string will render list without icons.}

\item{is_divided}{If TRUE created list elements are divided}

\item{is_description}{If TRUE created list will have a description}
}
\description{
This creates a list with icons using Semantic UI
}
\examples{

list_content <- data.frame(
  header = paste("Header", 1:5),
  description = paste("Description", 1:5),
  stringsAsFactors = FALSE
)

# Create a 5 element divided list with alert icons and description
uilist(list_content, "alert", is_divided = TRUE, is_description = TRUE)
}
