% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DistToNearest.R
\name{plotDensityThreshold}
\alias{plotDensityThreshold}
\title{Plot findThreshold results for the density method}
\usage{
plotDensityThreshold(data, cross = NULL, xmin = NULL, xmax = NULL,
  breaks = NULL, binwidth = NULL, title = NULL, size = 1,
  silent = FALSE, ...)
}
\arguments{
\item{data}{\link{DensityThreshold} object output by the \code{"density"} method 
of \link{findThreshold}.}

\item{cross}{numeric vector of distances from \link{distToNearest} to draw as a
histogram below the \code{data} histogram for comparison purposes.}

\item{xmin}{minimum limit for plotting the x-axis. If \code{NULL} the limit will 
be set automatically.}

\item{xmax}{maximum limit for plotting the x-axis. If \code{NULL} the limit will 
be set automatically.}

\item{breaks}{number of breaks o show on the x-axis. If \code{NULL} the breaks will 
be set automatically.}

\item{binwidth}{binwidth for the histogram. If \code{NULL} the binwidth 
will be set automatically to the bandwidth parameter determined by
\link{findThreshold}.}

\item{title}{string defining the plot title.}

\item{size}{numeric value for the plot line sizes.}

\item{silent}{if \code{TRUE} do not draw the plot and just return the ggplot2 
object; if \code{FALSE} draw the plot.}

\item{...}{additional arguments to pass to ggplot2::theme.}
}
\value{
A ggplot object defining the plot.
}
\description{
\code{plotDensityThreshold} plots the results from \code{"density"} method of 
\link{findThreshold}, including the smoothed density estimate, input nearest neighbor 
distance histogram, and threshold selected.
}
\examples{
\donttest{
# Subset example data to one sample as a demo
data(ExampleDb, package="alakazam")
db <- subset(ExampleDb, SAMPLE == "-1h")

# Use nucleotide Hamming distance and normalize by junction length
db <- distToNearest(db, model="ham", normalize="len", nproc=1)

# To find the threshold cut, call findThreshold function for "gmm" method.
output <- findThreshold(db$DIST_NEAREST, method="density")
print(output)

# Plot
plotDensityThreshold(output)
}
}
\seealso{
See \link{DensityThreshold} for the the input object definition and 
          \link{findThreshold} for generating the input object. See 
          \link{distToNearest} calculating nearest neighbor distances.
}
