% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TargetingModels.R
\name{extendSubstitutionMatrix}
\alias{extendSubstitutionMatrix}
\title{Extends a substitution model to include Ns.}
\usage{
extendSubstitutionMatrix(substitutionModel)
}
\arguments{
\item{substitutionModel}{matrix of 5-mers substitution counts built by 
\code{\link{createSubstitutionMatrix}}.}
}
\value{
A 5x3125 matrix of normalized substitution rate for each 5-mer motif with 
          rows names defining the center nucleotide, one of \code{c("A", "C", "G", "T", "N")}, 
          and column names defining the 5-mer nucleotide sequence.
}
\description{
\code{extendSubstitutionMatrix} extends a 5-mer nucleotide substitution model 
with 5-mers that include Ns by averaging over all corresponding 5-mers without Ns.
}
\examples{
# Subset example data to one isotype and sample as a demo
db <- subset(InfluenzaDb, CPRIMER == "IGHA" & BARCODE == "RL014")

# Create model using only silent mutations and ignore multiple mutations
sub_model <- createSubstitutionMatrix(db, model="S", multipleMutation="ignore")
ext_model <- extendSubstitutionMatrix(sub_model)

}
\seealso{
Other targeting model functions: \code{\link{calcTargetingDistance}},
  \code{\link{createMutabilityMatrix}},
  \code{\link{createSubstitutionMatrix}},
  \code{\link{createTargetingMatrix}},
  \code{\link{createTargetingModel}},
  \code{\link{extendMutabilityMatrix}},
  \code{\link{plotMutability}},
  \code{\link{writeTargetingDistance}}
}

