% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotProfileDendrogram.R
\name{plotProfileDendrogram}
\alias{plotProfileDendrogram}
\title{Plot soil profiles below a dendrogram}
\usage{
plotProfileDendrogram(
  x,
  clust,
  rotateToProfileID = FALSE,
  scaling.factor = 0.01,
  width = 0.1,
  y.offset = 0.1,
  dend.y.scale = max(clust$height * 2, na.rm = TRUE),
  dend.color = par("fg"),
  dend.width = 1,
  debug = FALSE,
  ...
)
}
\arguments{
\item{x}{a \code{SoilProfileCollection} object}

\item{clust}{a hierarchical clustering object generated by \code{hclust}, \code{cluster::agnes}, or \code{cluster::diana}}

\item{rotateToProfileID}{logical, attempt rotation of dendrogram according to original profile IDs, requires \code{dendExtend} package}

\item{scaling.factor}{vertical scaling of the profile heights (may have to tinker with this)}

\item{width}{scaling of profile widths}

\item{y.offset}{vertical offset for top of profiles}

\item{dend.y.scale}{extent of y-axis (may have to tinker with this)}

\item{dend.color}{dendrogram line color}

\item{dend.width}{dendrogram line width}

\item{debug}{logical,optionally print debugging data}

\item{...}{additional arguments to \code{plotSPC}}
}
\value{
a \code{data.frame} of IDs and linking structure
}
\description{
Plot soil profiles below a dendrogram
}
\details{
This function places soil profile sketches below a dendrogram.
}
\note{
You may have to tinker with some of the arguments to get optimal arrangement and scaling of soil profiles.
}
\author{
D.E. Beaudette
}
\keyword{hplots}
