% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability_output.R
\name{Stable}
\alias{Stable}
\alias{SelectedVariables}
\alias{Adjacency}
\alias{Clusters}
\title{Stable results}
\usage{
Stable(stability, argmax_id = NULL, linkage = "complete")

SelectedVariables(stability, argmax_id = NULL)

Adjacency(stability, argmax_id = NULL)

Clusters(stability, linkage = "complete", argmax_id = NULL)
}
\arguments{
\item{stability}{output of \code{\link{VariableSelection}},
\code{\link{BiSelection}}, \code{\link{GraphicalModel}} or
\code{\link{Clustering}}.}

\item{argmax_id}{optional indices of hyper-parameters. If
\code{argmax_id=NULL}, the calibrated hyper-parameters are used.}

\item{linkage}{character string indicating the type of linkage used in
hierarchical clustering to define the stable clusters. Possible values
include \code{"complete"}, \code{"single"} and \code{"average"} (see
argument \code{"method"} in \code{\link[stats]{hclust}} for a full list).}
}
\value{
A binary vector or matrix encoding the selection status (\code{1} if
  selected, \code{0} otherwise) in stability selection or stable cluster
  membership in consensus clustering.
}
\description{
Extracts stable results for stability selection or consensus clustering.
}
\examples{
\donttest{
# Variable selection
set.seed(1)
simul <- SimulateRegression(pk = 20)
stab <- VariableSelection(xdata = simul$xdata, ydata = simul$ydata)
SelectedVariables(stab)
Stable(stab)

# Graphical model
set.seed(1)
simul <- SimulateGraphical(pk = 10)
stab <- GraphicalModel(xdata = simul$data)
Adjacency(stab)
Stable(stab)

# Clustering
set.seed(1)
simul <- SimulateClustering(
  n = c(30, 30, 30),
  nu_xc = 1
)
stab <- Clustering(xdata = simul$data)
Clusters(stab)
Stable(stab)
}
}
\seealso{
\code{\link{VariableSelection}}, \code{\link{BiSelection}},
  \code{\link{GraphicalModel}}, \code{\link{Clustering}}
}
