% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibration.R
\name{SelectedVariables}
\alias{SelectedVariables}
\title{Stably selected variables}
\usage{
SelectedVariables(stability, argmax_id = NULL)
}
\arguments{
\item{stability}{output of \code{\link{VariableSelection}}, or
\code{\link{BiSelection}}.}

\item{argmax_id}{optional matrix of parameter IDs. If \code{argmax_id=NULL},
the calibrated model is used.}
}
\value{
A binary vector encoding the selection status of the variables
  (\code{1} if selected, \code{0} otherwise).
}
\description{
Extracts the (calibrated) set of stably selected variables.
}
\examples{
\donttest{
# Data simulation
set.seed(1)
simul <- SimulateRegression(pk = 50)

# Stability selection
stab <- VariableSelection(xdata = simul$xdata, ydata = simul$ydata)

# Calibrated set
selected <- SelectedVariables(stab)

# User-defined parameters
myids <- matrix(c(50, 10), nrow = 1)
stab$Lambda[myids[1], 1] # corresponding penalty
stab$params$pi_list[myids[2]] # corresponding threshold
selected <- SelectedVariables(stab, argmax_id = myids)
}
}
\seealso{
\code{\link{VariableSelection}}, \code{\link{BiSelection}}

Other calibration functions: 
\code{\link{Adjacency}()},
\code{\link{ArgmaxId}()},
\code{\link{Argmax}()},
\code{\link{CalibrationPlot}()},
\code{\link{SelectionProportions}()}
}
\concept{calibration functions}
