% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.rd_pat.R
\name{plot.rd_pat}
\alias{plot.rd_pat}
\title{plot.rd_pat}
\usage{
\method{plot}{rd_pat}(
  x,
  what = "sf",
  n = NULL,
  probs = c(0.025, 0.975),
  comp_fast = 1000,
  ask = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{rd_pat object with randomized patterns.}

\item{what}{Character specifying to plot summary functions of point patterns
(\code{what = "sf"}) or actual patterns (\code{what = "pp"}).}

\item{n}{Integer with number or vector of ids of randomized pattern to plot.
See Details section for more information.}

\item{probs}{Vector with quantiles of randomized data used for envelope construction.}

\item{comp_fast}{Integer with threshold at which summary functions are estimated
in a computational fast way.}

\item{ask}{Logical if the user is asked to press <RETURN> before second summary function
is plotted (only used if \code{what = "sf"}).}

\item{verbose}{Logical if progress report is printed.}

\item{...}{Not used.}
}
\value{
void
}
\description{
Plot method for rd_pat object
}
\details{
The function plots the pair correlation function and the nearest neighbour function of
the observed pattern and the reconstructed patterns (as "simulation envelopes").
For large patterns \code{comp_fast = TRUE} decreases the computational demand because no edge
correction is used and the pair correlation function is estimated based on Ripley's
K-function. For more information see \code{\link{estimate_pcf_fast}}.

It is also possible to plot n randomized patterns and the observed pattern
using \code{what = "pp"}. If \code{n} is a single number, \code{n} randomized
patterns will be sampled to plot. If \code{n} is a vector, the corresponding patterns
will be plotted.
}
\examples{
\dontrun{
pattern_random <- fit_point_process(species_a, n_random = 39)
plot(pattern_random)

pattern_recon <- reconstruct_pattern(species_b, n_random = 19,
max_runs = 1000, method = "hetero")
plot(pattern_recon)
}

}
\seealso{
\code{\link{reconstruct_pattern}} \cr
\code{\link{fit_point_process}}
}
