% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sv_dependence.R
\name{potential_interactions}
\alias{potential_interactions}
\title{Strongest Interaction}
\usage{
potential_interactions(obj, v)
}
\arguments{
\item{obj}{An object of type "shapviz".}

\item{v}{Variable name.}
}
\value{
A named vector of average squared correlations, sorted in decreasing order.
}
\description{
This function tries to detect the approximately strongest interacting feature with
\code{v}. It works by calculating an average squared correlation between
the SHAP values of \code{v} and each feature across values of \code{v}.
To this purpose, a numeric \code{v} with more than \code{n_bins} unique values
is binned into that many quantile bins.
Currently \code{n_bins} equals the smaller of n/20 and sqrt(n), where n is the
sample size.
The average squared correlation is weighted by the number of non-missing feature
values in the bin. Note that non-numeric color features are turned to numeric
by calling \code{data.matrix}, which does not necessarily make sense.
}
\seealso{
\code{\link{sv_dependence}}.
}
