% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asymmetric_and_casual_Shapley.R
\name{prepare_data_causal}
\alias{prepare_data_causal}
\title{Generate data used for predictions and Monte Carlo integration for causal Shapley values}
\usage{
prepare_data_causal(internal, index_features = NULL, ...)
}
\arguments{
\item{internal}{List.
Not used directly, but passed through from \code{\link[=explain]{explain()}}.}

\item{index_features}{Positive integer vector. Specifies the id_coalition to
apply to the present method. \code{NULL} means all coalitions. Only used internally.}

\item{...}{Currently not used.}
}
\value{
A data.table containing simulated data that respects the (partial) causal ordering and the
the confounding assumptions. The data is used to estimate the contribution function by Monte Carlo integration.
}
\description{
This function loops over the given coalitions, and for each coalition it extracts the
chain of relevant sampling steps provided in \code{internal$object$S_causal}. This chain
can contain sampling from marginal and conditional distributions. We use the approach given by
\code{internal$parameters$approach} to generate the samples from the conditional distributions, and
we iteratively call \code{prepare_data()} with a modified \code{internal_copy} list to reuse code.
However, this also means that chains with the same conditional distributions will retrain a
model of said conditional distributions several times.
For the marginal distribution, we sample from the Gaussian marginals when the approach is
\code{gaussian} and from the marginals of the training data for all other approaches. Note that
we could extend the code to sample from the marginal (gaussian) copula, too, when \code{approach} is
\code{copula}.
}
\author{
Lars Henry Berge Olsen
}
\keyword{internal}
