% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/shapeR.R
\name{enrich.master.list}
\alias{enrich.master.list}
\title{Link information in the info.file to the coefficients obtained from the otolith images}
\usage{
enrich.master.list(object, folder_name = "folder", pic_name = "picname",
                   calibration = "cal", include.wavelet = TRUE, include.fourier = TRUE,
                   n.wavelet.levels = 5, n.fourier.freq = 12,...)
}
\arguments{
\item{object}{A \code{\linkS4class{shapeR}} object}

\item{folder_name}{Should contain the first letters of the area and the serie or station number of the sample, for example: "IC"}

\item{pic_name}{Should contain the serie number of a given sample and fish number, for example "403_2" (not including the .jpg extension)}

\item{calibration}{The name of the column where the pixels to measurement calibration is located}

\item{include.wavelet}{If TRUE, the wavelet coefficient are included in the master.list}

\item{include.fourier}{If TRUE then the Normalized Elliptic Fourier coefficients are included in the master.list}

\item{n.wavelet.levels}{Integer saying how many levels of wavelet levels should be included}

\item{n.fourier.freq}{Integer saying how many Fourier frequency levels should be included}

\item{...}{Additional parameter for \code{read.csv} for reading the info.file}
}
\value{
A \code{\linkS4class{shapeR}} object with values in slots:
\itemize{
  \item wavelet.coef
  \item fourier.coef
  \item shape
  \item filter
  \item master.list
}
}
\description{
Link the original info file to the otolith coefficients
}
\examples{
\dontrun{
data(shape)
shape = generateShapeCoefficients(shape)

shape = enrich.master.list(shape)}
}
\author{
Lisa Anne Libungan
}

