% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spacetime-cube-set-cols.R
\name{set_col}
\alias{set_col}
\alias{set_wts}
\alias{set_nbs}
\title{Set columns from \code{geometry} to \code{data}}
\usage{
set_col(x, .from_geo, .to_data = .from_geo)

set_wts(x, .wt_col = "wt")

set_nbs(x, .nb_col = "nb")
}
\arguments{
\item{x}{a spacetime object}

\item{.from_geo}{the name of the column in the \code{geometry} context}

\item{.to_data}{the name of the new variable to create in the \code{data} context}

\item{.wt_col}{the name of the weights column in the \code{geometry} context}

\item{.nb_col}{the name of neighbor column in the \code{geometry} context}
}
\value{
A spacetime object with an active data context and a new column from the geometry
context.
}
\description{
Set a column from the \code{geometry} context of a spacetime object to the \code{data}
context.
}
\details{
These functions will reorder the spacetime object to ensure that it is ordered
correctly based on the location time columns in the \code{geometry} context defined
by the \code{loc_col} and \code{time_col} attributes respectively.

\code{\link[=set_wts]{set_wts()}} and \code{\link[=set_nbs]{set_nbs()}} create a new column in the data context with the
same name as the column in the geometry context. If a different name is desired
use \code{\link[=set_col]{set_col()}}
}
\examples{
df_fp <- system.file("extdata", "bos-ecometric.csv", package = "sfdep")
geo_fp <- system.file("extdata", "bos-ecometric.geojson", package = "sfdep")

# read in data
df <- read.csv(
  df_fp, colClasses = c("character", "character", "integer", "double", "Date")
)
geo <- sf::st_read(geo_fp)

# Create spacetime object called `bos`
bos <- spacetime(df, geo,
                .loc_col = ".region_id",
                .time_col = "time_period")
bos <- activate(bos, "geometry")
bos$nb <- st_contiguity(bos)
bos$wt <- st_weights(bos$nb)
bos$card <- st_cardinalties(bos$nb)

set_nbs(bos)
set_wts(bos)
set_col(bos, "card")
set_col(bos, "card", "cardinalities")
}
