% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{testSet}
\alias{testSet}
\alias{checkSet}
\alias{assertSet}
\title{assert/check/test/Set}
\usage{
testSet(object, errormsg = "This is not an R6 Set object")

checkSet(object, errormsg = "This is not an R6 Set object")

assertSet(object, errormsg = "This is not an R6 Set object")
}
\arguments{
\item{object}{object to test}

\item{errormsg}{error message to overwrite default if check fails}
}
\value{
If check passes then \code{assert} returns \code{object} invisibly and \code{test}/\code{check}
return \code{TRUE}. If check fails, \code{assert} stops code with error, \code{check} returns
an error message as string, and \code{test} returns \code{FALSE}.
}
\description{
Validation checks to test if a given object is an R6 \code{Set}.
}
\examples{
testSet(Set$new(2, 3))
testSet(list(Set$new(2), Set$new(3)))
testSet(Tuple$new(2, 3))
testSet(Interval$new())
testSet(FuzzySet$new(2, 0.1))
testSet(FuzzyTuple$new(2, 0.1))
testSet(ConditionalSet$new(function(x) x == 0))
}
