% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{testCountablyFinite}
\alias{testCountablyFinite}
\alias{checkCountablyFinite}
\alias{assertCountablyFinite}
\title{assert/check/test/CountablyFinite}
\usage{
testCountablyFinite(object, errormsg = "This is not a countably finite set")

checkCountablyFinite(object, errormsg = "This is not a countably finite set")

assertCountablyFinite(object, errormsg = "This is not a countably finite set")
}
\arguments{
\item{object}{object to test}

\item{errormsg}{error message to overwrite default if check fails}
}
\value{
If check passes then \code{assert} returns \code{object} invisibly and \code{test}/\code{check}
return \code{TRUE}. If check fails, \code{assert} stops code with error, \code{check} returns
an error message as string, and \code{test} returns \code{FALSE}.
}
\description{
Validation checks to test if a given object is countablyfinite.
}
\examples{
testCountablyFinite(Set$new(1,2,3))
testCountablyFinite(Interval$new(1,10))
}
