% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SetWrapper_PowersetSet.R
\name{PowersetSet}
\alias{PowersetSet}
\title{Set of Powersets}
\description{
PowersetSet class for symbolic powerset of mathematical sets.
}
\details{
The purpose of this class is to provide a symbolic representation for the powerset of sets that
cannot be represented in a simpler class. Whilst this is not an abstract class, it is not recommended to construct
this class directly but via the set operation methods.
}
\seealso{
Set operations: \link{setunion}, \link{setproduct}, \link{setpower}, \link{setcomplement}, \link{setsymdiff},  \link{powerset}, \link{setintersect}

Other wrappers: 
\code{\link{ComplementSet}},
\code{\link{ExponentSet}},
\code{\link{ProductSet}},
\code{\link{UnionSet}}
}
\concept{wrappers}
\section{Super classes}{
\code{\link[set6:Set]{set6::Set}} -> \code{\link[set6:SetWrapper]{set6::SetWrapper}} -> \code{\link[set6:ProductSet]{set6::ProductSet}} -> \code{PowersetSet}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{PowersetSet$new()}}
\item \href{#method-strprint}{\code{PowersetSet$strprint()}}
\item \href{#method-contains}{\code{PowersetSet$contains()}}
\item \href{#method-isSubset}{\code{PowersetSet$isSubset()}}
\item \href{#method-clone}{\code{PowersetSet$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="Set" data-id="add">}\href{../../set6/html/Set.html#method-add}{\code{set6::Set$add()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="Set" data-id="print">}\href{../../set6/html/Set.html#method-print}{\code{set6::Set$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="Set" data-id="remove">}\href{../../set6/html/Set.html#method-remove}{\code{set6::Set$remove()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="Set" data-id="summary">}\href{../../set6/html/Set.html#method-summary}{\code{set6::Set$summary()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="SetWrapper" data-id="equals">}\href{../../set6/html/SetWrapper.html#method-equals}{\code{set6::SetWrapper$equals()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
Create a new \code{PowersetSet} object. It is not recommended to construct this class directly.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PowersetSet$new(set)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{set}}{\link{Set} to wrap.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{PowersetSet} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-strprint"></a>}}
\subsection{Method \code{strprint()}}{
Creates a printable representation of the object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PowersetSet$strprint(n = 2)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{numeric. Number of elements to display on either side of ellipsis when printing.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character string representing the object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-contains"></a>}}
\subsection{Method \code{contains()}}{
Tests if elements \code{x} are contained in \code{self}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PowersetSet$contains(x, all = FALSE, bound = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{\link{Set} or vector of \link{Set}s.}

\item{\code{x}}{\link{Set} or vector of \link{Set}s.}

\item{\code{all}}{logical. If \code{FALSE} tests each \code{x} separately. Otherwise returns \code{TRUE} only if all \code{x} pass test.}

\item{\code{all}}{logical. If \code{FALSE} tests each \code{x} separately. Otherwise returns \code{TRUE} only if all \code{x} pass test.}

\item{\code{bound}}{logical}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If \code{all == TRUE} then returns \code{TRUE} if all \code{x} are contained in \code{self}, otherwise \code{FALSE}.
If \code{all == FALSE} returns a vector of logicals corresponding to the length of \code{x}, representing
if each is contained in \code{self}. If \code{bound == TRUE} then an element is contained in \code{self} if it
is on or within the (possibly-open) bounds of \code{self}, otherwise \code{TRUE} only if the element is within
\code{self} or the bounds are closed.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-isSubset"></a>}}
\subsection{Method \code{isSubset()}}{
Tests if \code{x} is a (proper) subset of \code{self}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PowersetSet$isSubset(x, proper = FALSE, all = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{\link{Set} or vector of \link{Set}s.}

\item{\code{x}}{\link{Set} or vector of \link{Set}s.}

\item{\code{proper}}{logical. If \code{TRUE} tests for proper subsets.}

\item{\code{all}}{logical. If \code{FALSE} tests each \code{x} separately. Otherwise returns \code{TRUE} only if all \code{x} pass test.}

\item{\code{all}}{logical. If \code{FALSE} tests each \code{x} separately. Otherwise returns \code{TRUE} only if all \code{x} pass test.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If \code{all == TRUE} then returns \code{TRUE} if all \code{x} are (proper) subsets of \code{self}, otherwise \code{FALSE}.
If \code{all == FALSE} returns a vector of logicals corresponding to the length of \code{x}, representing
if each is a (proper) subset of \code{self}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PowersetSet$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
