% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set6.R
\docType{package}
\name{set6-package}
\alias{set6}
\alias{set6-package}
\title{set6: R6 Mathematical Sets Interface}
\description{
set6 upgrades the \code{{sets}} package to R6. Many forms of mathematical sets are implemented,
including (countably finite) sets, tuples, intervals (countably infinite or uncountable),
and fuzzy variants. Wrappers extend functionality by allowing symbolic representations of
complex operations on sets, including unions, (cartesian) products, exponentiation, and
differences (asymmetric and symmetric).
}
\details{
The main features of set6 are:

\itemize{
\item Object-oriented programming, which allows a clear inheritance structure for Sets, Intervals,
Tuples, and other variants.
\item Set operations and wrappers for both explicit and symbolic representations for algebra of sets.
\item Methods for assertions and comparison checks, including subsets, equality, and containedness.
}

To learn more about set6, start with the set6 vignette:

\code{vignette("set6", "set6")}

And for more advanced usage see the complete tutorials at

\href{https://raphaels1.github.io/set6/}{https://raphaels1.github.io/set6/}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://raphaels1.github.io/set6/}
  \item \url{https://github.com/RaphaelS1/set6}
}

}
\author{
\strong{Maintainer}: Raphael Sonabend \email{raphael.sonabend.15@ucl.ac.uk} (\href{https://orcid.org/0000-0001-9225-4654}{ORCID})

Authors:
\itemize{
  \item Franz Kiraly \email{f.kiraly@ucl.ac.uk}
}

}
