% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeqListSummary.R
\name{SummarySeq}
\alias{SummarySeq}
\title{Summarise sequoia output or pedigree}
\usage{
SummarySeq(SeqList = NULL, Ped = NULL, DumPrefix = c("F0", "M0"),
  SNPd = NULL, Plot = TRUE)
}
\arguments{
\item{SeqList}{the list returned by \code{\link{sequoia}}. Only elements
'Pedigree' or 'PedigreePar' and 'AgePriors' are used.}

\item{Ped}{Dataframe, pedigree with the first three columns being id - dam -
sire. Column names are ignored, as are additional columns.}

\item{DumPrefix}{character vector of length 2 with prefixes for dummy dams
(mothers) and sires (fathers). Will be read from \code{SeqList}'s 'Specs'
if provided. Used to distinguish between dummies and non-dummies.}

\item{SNPd}{character vector with ids of SNP genotyped individuals. Only when
\code{Ped} is provided instead of \code{SeqList}, then used to distinguish
between genetically assigned parents and 'observed' parents (e.g. observed
in the field, or assigned previously using microsatellites). Will be read
from \code{SeqList}'s 'PedigreePar' if provided.}

\item{Plot}{Show barplots and histograms of the results, as well as of the
parental LLRs, Mendelian errors, and agepriors, if present.}
}
\value{
A list with the following elements:
  \item{ParentCount}{a 2x3x2x4 array with the number of assigned parents,
  split by D1: genotyped vs dummy individuals; D2: female, male and
  unknown-sex individuals; D3: dams vs sires; D4: genotyped, dummy, observed
  vs no parent}
  \item{GPCount}{a 4x4 matrix with for all genotyped individuals the number
  of assigned grandparents, split by D1: Maternal grandmother, maternal
  grandfather, paternal grandmother, paternal grandfather; D2: genotyped,
  dummy, observed vs no grandparent}
  \item{SibSize}{a list with as first element a table of maternal sibship
  sizes, and as second element a table of paternal sibship sizes. Each table
  is a matrix with a number of rows equal to the  maximum sibship size, and 3
  columns, splitting by the type of parent: genotyped, dummy, or observed.}
}
\description{
Number of assigned parents and grandparents and sibship sizes,
  split by genotyped, dummy, and 'observed'.
}
\examples{
\dontrun{
data(SimGeno_example, LH_HSg5, package="sequoia")
SeqOUT <- sequoia(GenoM = SimGeno_example,
                   LifeHistData = LH_HSg5, MaxSibIter = 10)
Ped_example <- SeqOUT$Pedigree
Ped_example$dam[1:20] <- paste0("Mum", 1:20)  # some field mums
SummarySeq(SeqOUT, Ped=Ped_example)
}

}
\seealso{
\code{\link{sequoia}}
}
