% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ase_seq_logit.R
\name{ase_seq_logit}
\alias{ase_seq_logit}
\title{variable selection and stopping criterion}
\usage{
ase_seq_logit(X, Y, intercept = FALSE, criterion = "BIC", dlen = 0.5,
  alpha = 0.95, gamma = 1, eta = 0.75, upper = 2, lower = 0.1,
  divid.num = 10)
}
\arguments{
\item{X}{A dataframe that each row is a sample,each column represents an
independent variable.}

\item{Y}{Numeric vector consists of 0 or 1. The length of Y must be the same
as the X.}

\item{intercept}{A logical value indicating whether add intercept to model.
The default value is FALSE.}

\item{criterion}{For the "chosfun" methods, a character string that
determines the model selection criterion to be used, matching one of 'BIC'
or 'AIC. The default value is 'BIC'.}

\item{dlen}{A numeric number specifying the length of the fixed size
confidence set for our model. Note that the smaller the dlen, the larger
the sample size and the longer the time costs. The default value is 0.5.}

\item{alpha}{A numeric number used in the chi-square distribution. The
default value is 0.95.}

\item{gamma}{A numeric number to determine the effective variables with eta.
The default value is 1.}

\item{eta}{A numeric number to determine the effective variables with gamma.
The default value is 0.75.}

\item{upper}{A numeric number to choose the right epsilon with params lower
and divide.num. The value of upper should be larger than lower. The default
value is 2.}

\item{lower}{A numeric number to choose the right epsilon with params upper
and divide.num. The default value is 0.1.}

\item{divid.num}{A numeric number to choose the right epsilon with params
upper and lower. Note that it should be a integer. The default value is 10.}
}
\value{
a list containing the following components
\item{N}{current sample size}
\item{lab.stop}{the label of sequential stop or not. When the value of
lab.seq is 1, it means the iteration stops}
\item{betahat}{the estimated coefficients based on current X and Y. Note that
some coefficient will be zero. These are the non-effectiva variables should
be ignored.}
\item{phat}{the number of effective varriables.}
\item{ak}{1-alpha quantile of chisquare distribution with degree of freedom
phat}
\item{lamdmax}{the maximum eigenvalue based on the covariance of data}
}
\description{
\code{ase_seq_logit} determine the effective variables and whether to stop
selecting samples
}
\details{
ase_seq_logit estimates the logistic regression coefficient and determines
the effecrive variables and decides whether to stop selecting samples based
on the current sample and its corresponding label. The parameters 'upper',
'lower' and 'divid.num' is used to get different epsilons. If different
epsilons get the same value, we choose the smallest epsilon.
}
