% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridplot.R
\name{gridplot}
\alias{gridplot}
\title{Plot Multidimensional Sequence Plots in a Grid}
\usage{
gridplot(
  x,
  nrow = NA,
  ncol = NA,
  byrow = FALSE,
  with.legend = "auto",
  legend.pos = "auto",
  legend.pos2 = "center",
  title.legend = "auto",
  ncol.legend = "auto",
  with.missing.legend = "auto",
  row.prop = "auto",
  col.prop = "auto",
  cex.legend = 1
)
}
\arguments{
\item{x}{A list of \code{\link{ssp}} objects.}

\item{nrow, ncol}{Optional arguments to arrange plots.}

\item{byrow}{Controls the order of plotting. Defaults to \code{FALSE}, i.e. plots
are arranged column-wise.}

\item{with.legend}{Defines if and how the legends for the states are plotted.
The default value \code{"auto"} (equivalent to \code{TRUE} and
\code{"many"}) creates separate legends for each requested plot. Other
possibilities are \code{"combined"} (all legends combined) and \code{FALSE}
(no legend).}

\item{legend.pos}{Defines the positions of the legend boxes relative to the
whole plot. Either one of \code{"bottom"} (equivalent to \code{"auto"}) or
\code{"right"}, or a numerical vector of grid cells (by order) to print the
legends to (the cells must be in one row/column).}

\item{legend.pos2}{Defines the positions of the legend boxes relative to the
cell(s). One of \code{"bottomright"}, \code{"bottom"}, \code{"bottomleft"},
\code{"left"}, \code{"topleft"}, \code{"top"} (the default), \code{"topright"},
\code{"right"} and \code{"center"}.}

\item{title.legend}{The titles for the legend boxes. The default \code{"auto"} takes
the titles from the channel labels provided by the first object in \code{x}.
\code{NA} prints no title.}

\item{ncol.legend}{(A vector of) the number of columns for the legend(s). The
default \code{"auto"} creates one column for each legend.}

\item{with.missing.legend}{If set to \code{"auto"} (the default), a legend
for the missing state is added automatically if one or more of the
sequences in data contain missing states. With the value \code{TRUE} a
legend for the missing state is added in any case; equivalently
\code{FALSE} omits the legend for the missing state.}

\item{row.prop}{Sets the proportions of the row heights of the grid. The default
value is \code{"auto"} for even row heights. Takes a vector of values from
0 to 1, with values summing to 1.}

\item{col.prop}{Sets the proportion of the column heights of the grid. The default
value is \code{"auto"} for even column widths. Takes a vector of values
from 0 to 1, with values summing to 1.}

\item{cex.legend}{Expansion factor for setting the size of the font for the
labels in the legend. The default value is 1. Values lesser than 1 will
reduce the size of the font, values greater than 1 will increase the size.}
}
\description{
Function \code{gridplot} plots multiple \code{ssp} objects to a
grid.
}
\examples{
\dontrun{
data("biofam3c")

# Creating sequence objects
child_seq <- seqdef(biofam3c$children, start = 15)
marr_seq <- seqdef(biofam3c$married, start = 15)
left_seq <- seqdef(biofam3c$left, start = 15)

## Choosing colors
attr(child_seq, "cpal") <- c("#66C2A5", "#FC8D62")
attr(marr_seq, "cpal") <- c("#AB82FF", "#E6AB02", "#E7298A")
attr(left_seq, "cpal") <- c("#A6CEE3", "#E31A1C")


# Preparing plot for state distribution plots of observations for women
ssp_f <- ssp(
  list(child_seq[biofam3c$covariates$sex == "woman",],
       marr_seq[biofam3c$covariates$sex == "woman",],
       left_seq[biofam3c$covariates$sex == "woman",]),
  type = "d", plots = "obs", title = "Women",
  ylab = c("Children", "Married", "Left home"))

# Preparing plot for state distribution plots of observations for men
# (Updating the previous plot, only arguments that change values)
ssp_m <- update(ssp_f, title = "Men",
  x = list(child_seq[biofam3c$covariates$sex == "man",],
       marr_seq[biofam3c$covariates$sex == "man",],
       left_seq[biofam3c$covariates$sex == "man",]))

# Plotting state distribution plots of observations for women and men in two columns
gridplot(list(ssp_f, ssp_m), ncol = 2, with.legend = FALSE)

# Preparing plots for women's state distributions
ssp_f2 <- ssp(
  list(marr_seq[biofam3c$covariates$sex == "woman",],
       child_seq[biofam3c$covariates$sex == "woman",],
       left_seq[biofam3c$covariates$sex == "woman",]),
  type = "d", border = NA, with.legend = FALSE,
  title = "State distributions for women", title.n = FALSE, xtlab = 15:30,
  ylab.pos = c(1, 2, 1), ylab = c("Married", "Children", "Left home"))

# The same plot with sequences instead of state distributions
ssp_f3 <- update(
  ssp_f2, type = "I", sortv = "mds.obs", title = "Sequences for women")

# State distributions with men's data
ssp_m2 <- update(
  ssp_f2, title = "State distributions for men",
  x = list(marr_seq[biofam3c$covariates$sex == "man",],
           child_seq[biofam3c$covariates$sex == "man",],
           left_seq[biofam3c$covariates$sex == "man",]))

# Men's sequences
ssp_m3 <- update(
  ssp_m2, type = "I", sortv = "mds.obs", title = "Sequences for men")

# Plotting state distributions and index plots of observations
# for women and men in two columns (+ one column for legends)
gridplot(
  list(ssp_f2, ssp_f3, ssp_m2, ssp_m3), ncol = 3, byrow = TRUE,
  with.legend = "combined", legend.pos = "right", col.prop = c(0.35, 0.35, 0.3))

# The same with different positioning and fixed cells for legends
gridplot(
  list(ssp_f2, ssp_f3, ssp_m2, ssp_m3), ncol = 2, nrow = 3, byrow = TRUE,
  # defining the legend positions by the cell numbers
  legend.pos = 3:4)
 }

}
\seealso{
\code{\link{ssp}} for defining the plot before using
  \code{gridplot}, and \code{\link{plot.ssp}} for plotting only one ssp object.
}
