% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/separate_mhmm.R
\name{separate_mhmm}
\alias{separate_mhmm}
\title{Reorganize a mixture hidden Markov model to a list of separate hidden Markov models
(covariates ignored)}
\usage{
separate_mhmm(model)
}
\arguments{
\item{model}{Mixture hidden Markov model of class \code{mhmm}.}
}
\value{
List with components of class \code{hmm}.
}
\description{
The \code{separate_mhmm} function reorganizes the parameters of a \code{mhmm} object
into a list where each list component is an object of class \code{hmm} consisting of the
parameters of the corresponding cluster.
}
\examples{
# Loading mixture hidden Markov model (mhmm object)
# of the biofam data
data("mhmm_biofam")

# Separate models for clusters
sep_hmm <- separate_mhmm(mhmm_biofam)

# Plotting the model for the first cluster
plot(sep_hmm[[1]])
}
\seealso{
\code{\link{build_mhmm}} and \code{\link{fit_model}}
for building and fitting MHMMs; and \code{\link{mhmm_biofam}} for
more information on the model used in examples.
}

