#' Color palettes
#'
#' A list containing ready defined color palettes with distinct colors using
#' iWantHue.
#'
#' @format A list with 200 color palettes.
#'
#' @source iWantHue web page \url{http://tools.medialab.sciences-po.fr/iwanthue/}
#'
#' @seealso Implementations of iWantHue for R:
#'   \itemize{
#'     \item \url{https://github.com/hoesler/rwantshue}
#'     \item \url{https://github.com/johnbaums/hues}
#'   }
#' @docType data
#' @keywords datasets
#' @name colorpalette
#' @examples
#' data("colorpalette")
#' # Color palette with 9 colors
#' colorpalette[[9]]
#' # Color palette with 24 colors
#' colorpalette[[24]]
#'
NULL



