% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentomeasures_methods.R
\name{subset.sento_measures}
\alias{subset.sento_measures}
\title{Subset sentiment measures}
\usage{
\method{subset}{sento_measures}(x, subset = NULL, select = NULL,
  delete = NULL, ...)
}
\arguments{
\item{x}{a \code{sento_measures} object created using \code{\link{sento_measures}}.}

\item{subset}{a logical (non-\code{character}) expression indicating the rows to keep. If a
\code{numeric} input is given, it is used for row index subsetting.}

\item{select}{a \code{character} vector of the lexicon, feature and time weighting scheme names, to indicate which
measures need to be selected, or as a \code{list} of \code{character} vectors, possibly with separately specified
combinations (consisting of one unique lexicon, one unique feature, and one unique time weighting scheme at maximum).}

\item{delete}{see the \code{select} argument.}

\item{...}{not used.}
}
\value{
A modified \code{sento_measures} object, with only the remaining rows and sentiment measures,
including updated information and statistics, but the original sentiment scores \code{data.table} untouched.
}
\description{
Subsets rows of the sentiment measures based on its columns.
}
\examples{
data("usnews", package = "sentometrics")
data("list_lexicons", package = "sentometrics")
data("list_valence_shifters", package = "sentometrics")

# construct a sento_measures object to start with
corpus <- sento_corpus(corpusdf = usnews)
corpusSample <- quanteda::corpus_sample(corpus, size = 500)
l <- sento_lexicons(list_lexicons[c("LM_en", "HENRY_en")])
ctr <- ctr_agg(howTime = c("equal_weight", "linear"), by = "year", lag = 3)
sm <- sento_measures(corpusSample, l, ctr)

# three specified indices in required list format
three <- as.list(
  stringi::stri_split(c("LM_en--economy--linear",
                        "HENRY_en--wsj--equal_weight",
                        "HENRY_en--wapo--equal_weight"),
                      regex = "--")
)

# different subsets
sub1 <- subset(sm, HENRY_en--economy--equal_weight >= 0.01)
sub2 <- subset(sm, date \%in\% get_dates(sm)[3:12])
sub3 <- subset(sm, 3:12)
sub4 <- subset(sm, 1:100) # warning

# different selections
sel1 <- subset(sm, select = "equal_weight")
sel2 <- subset(sm, select = c("equal_weight", "linear"))
sel3 <- subset(sm, select = c("linear", "LM_en"))
sel4 <- subset(sm, select = list(c("linear", "wsj"), c("linear", "economy")))
sel5 <- subset(sm, select = three)

# different deletions
del1 <- subset(sm, delete = "equal_weight")
del2 <- subset(sm, delete = c("linear", "LM_en"))
del3 <- subset(sm, delete = list(c("linear", "wsj"), c("linear", "economy")))
del4 <- subset(sm, delete = c("equal_weight", "linear")) # warning
del5 <- subset(sm, delete = three)

}
\author{
Samuel Borms
}
